<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleMonitoringPermissions StructType
 * Meta informations extracted from the WSDL
 * - documentation: Participant's permissions to use the service. | The Vehicle Monitors (DIUSPLAY ASSIGNMENTs) that the participant may access.
 * @subpackage Structs
 */
class VehicleMonitoringPermissions extends PermissionsStructure
{
    /**
     * The VehicleMonitoringPermission
     * Meta informations extracted from the WSDL
     * - documentation: Permissions for use of VEHICLE MONITORING. Can be used to specify which Consumers can see which vehicles
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VehicleMonitoringServicePermissionStructure[]
     */
    public $VehicleMonitoringPermission;
    /**
     * The AllowAll
     * Meta informations extracted from the WSDL
     * - ref: AllowAll
     * @var bool
     */
    public $AllowAll;
    /**
     * The VehicleMonitorPermission
     * Meta informations extracted from the WSDL
     * - documentation: Participant's permission for this Vehicle Monitor (DISPLAY SSIGNMENT).
     * - maxOccurs: unbounded
     * @var \StructType\VehicleMonitorPermissionStructure[]
     */
    public $VehicleMonitorPermission;
    /**
     * Constructor method for VehicleMonitoringPermissions
     * @uses VehicleMonitoringPermissions::setVehicleMonitoringPermission()
     * @uses VehicleMonitoringPermissions::setAllowAll()
     * @uses VehicleMonitoringPermissions::setVehicleMonitorPermission()
     * @param \StructType\VehicleMonitoringServicePermissionStructure[] $vehicleMonitoringPermission
     * @param bool $allowAll
     * @param \StructType\VehicleMonitorPermissionStructure[] $vehicleMonitorPermission
     */
    public function __construct(array $vehicleMonitoringPermission = array(), $allowAll = null, array $vehicleMonitorPermission = array())
    {
        $this
            ->setVehicleMonitoringPermission($vehicleMonitoringPermission)
            ->setAllowAll($allowAll)
            ->setVehicleMonitorPermission($vehicleMonitorPermission);
    }
    /**
     * Get VehicleMonitoringPermission value
     * @return \StructType\VehicleMonitoringServicePermissionStructure[]|null
     */
    public function getVehicleMonitoringPermission()
    {
        return $this->VehicleMonitoringPermission;
    }
    /**
     * Set VehicleMonitoringPermission value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleMonitoringServicePermissionStructure[] $vehicleMonitoringPermission
     * @return \StructType\VehicleMonitoringPermissions
     */
    public function setVehicleMonitoringPermission(array $vehicleMonitoringPermission = array())
    {
        foreach ($vehicleMonitoringPermission as $vehicleMonitoringPermissionsVehicleMonitoringPermissionItem) {
            // validation for constraint: itemType
            if (!$vehicleMonitoringPermissionsVehicleMonitoringPermissionItem instanceof \StructType\VehicleMonitoringServicePermissionStructure) {
                throw new \InvalidArgumentException(sprintf('The VehicleMonitoringPermission property can only contain items of \StructType\VehicleMonitoringServicePermissionStructure, "%s" given', is_object($vehicleMonitoringPermissionsVehicleMonitoringPermissionItem) ? get_class($vehicleMonitoringPermissionsVehicleMonitoringPermissionItem) : gettype($vehicleMonitoringPermissionsVehicleMonitoringPermissionItem)), __LINE__);
            }
        }
        $this->VehicleMonitoringPermission = $vehicleMonitoringPermission;
        return $this;
    }
    /**
     * Add item to VehicleMonitoringPermission value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleMonitoringServicePermissionStructure $item
     * @return \StructType\VehicleMonitoringPermissions
     */
    public function addToVehicleMonitoringPermission(\StructType\VehicleMonitoringServicePermissionStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleMonitoringServicePermissionStructure) {
            throw new \InvalidArgumentException(sprintf('The VehicleMonitoringPermission property can only contain items of \StructType\VehicleMonitoringServicePermissionStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehicleMonitoringPermission[] = $item;
        return $this;
    }
    /**
     * Get AllowAll value
     * @return bool|null
     */
    public function getAllowAll()
    {
        return $this->AllowAll;
    }
    /**
     * Set AllowAll value
     * @param bool $allowAll
     * @return \StructType\VehicleMonitoringPermissions
     */
    public function setAllowAll($allowAll = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowAll) && !is_bool($allowAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowAll)), __LINE__);
        }
        $this->AllowAll = $allowAll;
        return $this;
    }
    /**
     * Get VehicleMonitorPermission value
     * @return \StructType\VehicleMonitorPermissionStructure[]|null
     */
    public function getVehicleMonitorPermission()
    {
        return $this->VehicleMonitorPermission;
    }
    /**
     * Set VehicleMonitorPermission value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleMonitorPermissionStructure[] $vehicleMonitorPermission
     * @return \StructType\VehicleMonitoringPermissions
     */
    public function setVehicleMonitorPermission(array $vehicleMonitorPermission = array())
    {
        foreach ($vehicleMonitorPermission as $vehicleMonitoringPermissionsVehicleMonitorPermissionItem) {
            // validation for constraint: itemType
            if (!$vehicleMonitoringPermissionsVehicleMonitorPermissionItem instanceof \StructType\VehicleMonitorPermissionStructure) {
                throw new \InvalidArgumentException(sprintf('The VehicleMonitorPermission property can only contain items of \StructType\VehicleMonitorPermissionStructure, "%s" given', is_object($vehicleMonitoringPermissionsVehicleMonitorPermissionItem) ? get_class($vehicleMonitoringPermissionsVehicleMonitorPermissionItem) : gettype($vehicleMonitoringPermissionsVehicleMonitorPermissionItem)), __LINE__);
            }
        }
        $this->VehicleMonitorPermission = $vehicleMonitorPermission;
        return $this;
    }
    /**
     * Add item to VehicleMonitorPermission value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleMonitorPermissionStructure $item
     * @return \StructType\VehicleMonitoringPermissions
     */
    public function addToVehicleMonitorPermission(\StructType\VehicleMonitorPermissionStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleMonitorPermissionStructure) {
            throw new \InvalidArgumentException(sprintf('The VehicleMonitorPermission property can only contain items of \StructType\VehicleMonitorPermissionStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehicleMonitorPermission[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleMonitoringPermissions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
