<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleMonitoringDeliveryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Delivery for Vehicle Monitoring Service. Provides information about one or more vehicles; each has its own VEHICLE activity element.
 * @subpackage Structs
 */
class VehicleMonitoringDeliveryStructure extends AbstractServiceDeliveryStructure
{
    /**
     * The VehicleActivity
     * @var \StructType\VehicleActivityStructure
     */
    public $VehicleActivity;
    /**
     * The VehicleActivityCancellation
     * @var \StructType\VehicleActivityCancellationStructure
     */
    public $VehicleActivityCancellation;
    /**
     * The VehicleActivityNote
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $VehicleActivityNote;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for VehicleMonitoringDeliveryStructure
     * @uses VehicleMonitoringDeliveryStructure::setVehicleActivity()
     * @uses VehicleMonitoringDeliveryStructure::setVehicleActivityCancellation()
     * @uses VehicleMonitoringDeliveryStructure::setVehicleActivityNote()
     * @uses VehicleMonitoringDeliveryStructure::setExtensions()
     * @uses VehicleMonitoringDeliveryStructure::setVersion()
     * @param \StructType\VehicleActivityStructure $vehicleActivity
     * @param \StructType\VehicleActivityCancellationStructure $vehicleActivityCancellation
     * @param \StructType\NaturalLanguageStringStructure $vehicleActivityNote
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\VehicleActivityStructure $vehicleActivity = null, \StructType\VehicleActivityCancellationStructure $vehicleActivityCancellation = null, \StructType\NaturalLanguageStringStructure $vehicleActivityNote = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setVehicleActivity($vehicleActivity)
            ->setVehicleActivityCancellation($vehicleActivityCancellation)
            ->setVehicleActivityNote($vehicleActivityNote)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get VehicleActivity value
     * @return \StructType\VehicleActivityStructure|null
     */
    public function getVehicleActivity()
    {
        return $this->VehicleActivity;
    }
    /**
     * Set VehicleActivity value
     * @param \StructType\VehicleActivityStructure $vehicleActivity
     * @return \StructType\VehicleMonitoringDeliveryStructure
     */
    public function setVehicleActivity(\StructType\VehicleActivityStructure $vehicleActivity = null)
    {
        $this->VehicleActivity = $vehicleActivity;
        return $this;
    }
    /**
     * Get VehicleActivityCancellation value
     * @return \StructType\VehicleActivityCancellationStructure|null
     */
    public function getVehicleActivityCancellation()
    {
        return $this->VehicleActivityCancellation;
    }
    /**
     * Set VehicleActivityCancellation value
     * @param \StructType\VehicleActivityCancellationStructure $vehicleActivityCancellation
     * @return \StructType\VehicleMonitoringDeliveryStructure
     */
    public function setVehicleActivityCancellation(\StructType\VehicleActivityCancellationStructure $vehicleActivityCancellation = null)
    {
        $this->VehicleActivityCancellation = $vehicleActivityCancellation;
        return $this;
    }
    /**
     * Get VehicleActivityNote value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getVehicleActivityNote()
    {
        return $this->VehicleActivityNote;
    }
    /**
     * Set VehicleActivityNote value
     * @param \StructType\NaturalLanguageStringStructure $vehicleActivityNote
     * @return \StructType\VehicleMonitoringDeliveryStructure
     */
    public function setVehicleActivityNote(\StructType\NaturalLanguageStringStructure $vehicleActivityNote = null)
    {
        $this->VehicleActivityNote = $vehicleActivityNote;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\VehicleMonitoringDeliveryStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\VehicleMonitoringDeliveryStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleMonitoringDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
