<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleActivityStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for a Vehicle Activity.
 * @subpackage Structs
 */
class VehicleActivityStructure extends AbstractIdentifiedItemStructure
{
    /**
     * The ValidUntilTime
     * Meta informations extracted from the WSDL
     * - documentation: Time until when data is valid.
     * @var string
     */
    public $ValidUntilTime;
    /**
     * The VehicleMonitoringRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to monitored VEHICLE or GROUP OF VEHICLEs.
     * - minOccurs: 0
     * @var \StructType\VehicleMonitoringRefStructure
     */
    public $VehicleMonitoringRef;
    /**
     * The MonitoringName
     * Meta informations extracted from the WSDL
     * - documentation: Name associated with Monitoring Reference. Supports SIRI LITE servcies (+SIRI v2.0).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $MonitoringName;
    /**
     * The ProgressBetweenStops
     * Meta informations extracted from the WSDL
     * - documentation: Provides information about the progress of the VEHICLE along its current link, that is link from previous visited top to current position.
     * - minOccurs: 0
     * @var \StructType\ProgressBetweenStopsStructure
     */
    public $ProgressBetweenStops;
    /**
     * The MonitoredVehicleJourney
     * @var \StructType\MonitoredVehicleJourney
     */
    public $MonitoredVehicleJourney;
    /**
     * The VehicleActivityNote
     * Meta informations extracted from the WSDL
     * - documentation: Text associated with Delivery.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $VehicleActivityNote;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for VehicleActivityStructure
     * @uses VehicleActivityStructure::setValidUntilTime()
     * @uses VehicleActivityStructure::setVehicleMonitoringRef()
     * @uses VehicleActivityStructure::setMonitoringName()
     * @uses VehicleActivityStructure::setProgressBetweenStops()
     * @uses VehicleActivityStructure::setMonitoredVehicleJourney()
     * @uses VehicleActivityStructure::setVehicleActivityNote()
     * @uses VehicleActivityStructure::setExtensions()
     * @param string $validUntilTime
     * @param \StructType\VehicleMonitoringRefStructure $vehicleMonitoringRef
     * @param \StructType\NaturalLanguageStringStructure[] $monitoringName
     * @param \StructType\ProgressBetweenStopsStructure $progressBetweenStops
     * @param \StructType\MonitoredVehicleJourney $monitoredVehicleJourney
     * @param \StructType\NaturalLanguageStringStructure[] $vehicleActivityNote
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($validUntilTime = null, \StructType\VehicleMonitoringRefStructure $vehicleMonitoringRef = null, array $monitoringName = array(), \StructType\ProgressBetweenStopsStructure $progressBetweenStops = null, \StructType\MonitoredVehicleJourney $monitoredVehicleJourney = null, array $vehicleActivityNote = array(), \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setValidUntilTime($validUntilTime)
            ->setVehicleMonitoringRef($vehicleMonitoringRef)
            ->setMonitoringName($monitoringName)
            ->setProgressBetweenStops($progressBetweenStops)
            ->setMonitoredVehicleJourney($monitoredVehicleJourney)
            ->setVehicleActivityNote($vehicleActivityNote)
            ->setExtensions($extensions);
    }
    /**
     * Get ValidUntilTime value
     * @return string|null
     */
    public function getValidUntilTime()
    {
        return $this->ValidUntilTime;
    }
    /**
     * Set ValidUntilTime value
     * @param string $validUntilTime
     * @return \StructType\VehicleActivityStructure
     */
    public function setValidUntilTime($validUntilTime = null)
    {
        // validation for constraint: string
        if (!is_null($validUntilTime) && !is_string($validUntilTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validUntilTime)), __LINE__);
        }
        $this->ValidUntilTime = $validUntilTime;
        return $this;
    }
    /**
     * Get VehicleMonitoringRef value
     * @return \StructType\VehicleMonitoringRefStructure|null
     */
    public function getVehicleMonitoringRef()
    {
        return $this->VehicleMonitoringRef;
    }
    /**
     * Set VehicleMonitoringRef value
     * @param \StructType\VehicleMonitoringRefStructure $vehicleMonitoringRef
     * @return \StructType\VehicleActivityStructure
     */
    public function setVehicleMonitoringRef(\StructType\VehicleMonitoringRefStructure $vehicleMonitoringRef = null)
    {
        $this->VehicleMonitoringRef = $vehicleMonitoringRef;
        return $this;
    }
    /**
     * Get MonitoringName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getMonitoringName()
    {
        return $this->MonitoringName;
    }
    /**
     * Set MonitoringName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $monitoringName
     * @return \StructType\VehicleActivityStructure
     */
    public function setMonitoringName(array $monitoringName = array())
    {
        foreach ($monitoringName as $vehicleActivityStructureMonitoringNameItem) {
            // validation for constraint: itemType
            if (!$vehicleActivityStructureMonitoringNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The MonitoringName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($vehicleActivityStructureMonitoringNameItem) ? get_class($vehicleActivityStructureMonitoringNameItem) : gettype($vehicleActivityStructureMonitoringNameItem)), __LINE__);
            }
        }
        $this->MonitoringName = $monitoringName;
        return $this;
    }
    /**
     * Add item to MonitoringName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\VehicleActivityStructure
     */
    public function addToMonitoringName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The MonitoringName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MonitoringName[] = $item;
        return $this;
    }
    /**
     * Get ProgressBetweenStops value
     * @return \StructType\ProgressBetweenStopsStructure|null
     */
    public function getProgressBetweenStops()
    {
        return $this->ProgressBetweenStops;
    }
    /**
     * Set ProgressBetweenStops value
     * @param \StructType\ProgressBetweenStopsStructure $progressBetweenStops
     * @return \StructType\VehicleActivityStructure
     */
    public function setProgressBetweenStops(\StructType\ProgressBetweenStopsStructure $progressBetweenStops = null)
    {
        $this->ProgressBetweenStops = $progressBetweenStops;
        return $this;
    }
    /**
     * Get MonitoredVehicleJourney value
     * @return \StructType\MonitoredVehicleJourney|null
     */
    public function getMonitoredVehicleJourney()
    {
        return $this->MonitoredVehicleJourney;
    }
    /**
     * Set MonitoredVehicleJourney value
     * @param \StructType\MonitoredVehicleJourney $monitoredVehicleJourney
     * @return \StructType\VehicleActivityStructure
     */
    public function setMonitoredVehicleJourney(\StructType\MonitoredVehicleJourney $monitoredVehicleJourney = null)
    {
        $this->MonitoredVehicleJourney = $monitoredVehicleJourney;
        return $this;
    }
    /**
     * Get VehicleActivityNote value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getVehicleActivityNote()
    {
        return $this->VehicleActivityNote;
    }
    /**
     * Set VehicleActivityNote value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $vehicleActivityNote
     * @return \StructType\VehicleActivityStructure
     */
    public function setVehicleActivityNote(array $vehicleActivityNote = array())
    {
        foreach ($vehicleActivityNote as $vehicleActivityStructureVehicleActivityNoteItem) {
            // validation for constraint: itemType
            if (!$vehicleActivityStructureVehicleActivityNoteItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The VehicleActivityNote property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($vehicleActivityStructureVehicleActivityNoteItem) ? get_class($vehicleActivityStructureVehicleActivityNoteItem) : gettype($vehicleActivityStructureVehicleActivityNoteItem)), __LINE__);
            }
        }
        $this->VehicleActivityNote = $vehicleActivityNote;
        return $this;
    }
    /**
     * Add item to VehicleActivityNote value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\VehicleActivityStructure
     */
    public function addToVehicleActivityNote(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The VehicleActivityNote property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehicleActivityNote[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\VehicleActivityStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleActivityStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
