<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidityConditionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for a validity condition.
 * @subpackage Structs
 */
class ValidityConditionStructure extends AbstractStructBase
{
    /**
     * The FromDateTime
     * Meta informations extracted from the WSDL
     * - documentation: The (inclusive) start date and time.
     * - minOccurs: 0
     * @var string
     */
    public $FromDateTime;
    /**
     * The ToDateTime
     * Meta informations extracted from the WSDL
     * - documentation: The (inclusive) end time. If omitted, the range end is open-ended, that is, it should be interpreted as "forever".
     * - minOccurs: 0
     * @var string
     */
    public $ToDateTime;
    /**
     * The DayType
     * Meta informations extracted from the WSDL
     * - documentation: Day type for which timeband applies. If absent all day types in context.
     * - minOccurs: 0
     * @var string
     */
    public $DayType;
    /**
     * The Timebands
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Timebands[]
     */
    public $Timebands;
    /**
     * Constructor method for ValidityConditionStructure
     * @uses ValidityConditionStructure::setFromDateTime()
     * @uses ValidityConditionStructure::setToDateTime()
     * @uses ValidityConditionStructure::setDayType()
     * @uses ValidityConditionStructure::setTimebands()
     * @param string $fromDateTime
     * @param string $toDateTime
     * @param string $dayType
     * @param \StructType\Timebands[] $timebands
     */
    public function __construct($fromDateTime = null, $toDateTime = null, $dayType = null, array $timebands = array())
    {
        $this
            ->setFromDateTime($fromDateTime)
            ->setToDateTime($toDateTime)
            ->setDayType($dayType)
            ->setTimebands($timebands);
    }
    /**
     * Get FromDateTime value
     * @return string|null
     */
    public function getFromDateTime()
    {
        return $this->FromDateTime;
    }
    /**
     * Set FromDateTime value
     * @param string $fromDateTime
     * @return \StructType\ValidityConditionStructure
     */
    public function setFromDateTime($fromDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($fromDateTime) && !is_string($fromDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromDateTime)), __LINE__);
        }
        $this->FromDateTime = $fromDateTime;
        return $this;
    }
    /**
     * Get ToDateTime value
     * @return string|null
     */
    public function getToDateTime()
    {
        return $this->ToDateTime;
    }
    /**
     * Set ToDateTime value
     * @param string $toDateTime
     * @return \StructType\ValidityConditionStructure
     */
    public function setToDateTime($toDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($toDateTime) && !is_string($toDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toDateTime)), __LINE__);
        }
        $this->ToDateTime = $toDateTime;
        return $this;
    }
    /**
     * Get DayType value
     * @return string|null
     */
    public function getDayType()
    {
        return $this->DayType;
    }
    /**
     * Set DayType value
     * @param string $dayType
     * @return \StructType\ValidityConditionStructure
     */
    public function setDayType($dayType = null)
    {
        // validation for constraint: string
        if (!is_null($dayType) && !is_string($dayType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dayType)), __LINE__);
        }
        $this->DayType = $dayType;
        return $this;
    }
    /**
     * Get Timebands value
     * @return \StructType\Timebands[]|null
     */
    public function getTimebands()
    {
        return $this->Timebands;
    }
    /**
     * Set Timebands value
     * @throws \InvalidArgumentException
     * @param \StructType\Timebands[] $timebands
     * @return \StructType\ValidityConditionStructure
     */
    public function setTimebands(array $timebands = array())
    {
        foreach ($timebands as $validityConditionStructureTimebandsItem) {
            // validation for constraint: itemType
            if (!$validityConditionStructureTimebandsItem instanceof \StructType\Timebands) {
                throw new \InvalidArgumentException(sprintf('The Timebands property can only contain items of \StructType\Timebands, "%s" given', is_object($validityConditionStructureTimebandsItem) ? get_class($validityConditionStructureTimebandsItem) : gettype($validityConditionStructureTimebandsItem)), __LINE__);
            }
        }
        $this->Timebands = $timebands;
        return $this;
    }
    /**
     * Add item to Timebands value
     * @throws \InvalidArgumentException
     * @param \StructType\Timebands $item
     * @return \StructType\ValidityConditionStructure
     */
    public function addToTimebands(\StructType\Timebands $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Timebands) {
            throw new \InvalidArgumentException(sprintf('The Timebands property can only contain items of \StructType\Timebands, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Timebands[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidityConditionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
