<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserNeedStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for of a specific need. | one of the following.
 * @subpackage Structs
 */
class UserNeedStructure extends AbstractStructBase
{
    /**
     * The MobilityNeed
     * @var string
     */
    public $MobilityNeed;
    /**
     * The PsychosensoryNeed
     * @var string
     */
    public $PsychosensoryNeed;
    /**
     * The MedicalNeed
     * Meta informations extracted from the WSDL
     * - documentation: Passenger medical USER NEED for which SUITABILITY is specified.
     * @var MedicalNeedEnumeration
     */
    public $MedicalNeed;
    /**
     * The EncumbranceNeed
     * @var string
     */
    public $EncumbranceNeed;
    /**
     * The Excluded
     * Meta informations extracted from the WSDL
     * - documentation: Whether USER NEED is included or excluded. Default is 'included'.
     * - minOccurs: 0
     * @var bool
     */
    public $Excluded;
    /**
     * The NeedRanking
     * Meta informations extracted from the WSDL
     * - documentation: Relative ranking of USER NEED on a sclae 1-5
     * - minOccurs: 0
     * @var int
     */
    public $NeedRanking;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - documentation: Extensions to USETR NEED.
     * - minOccurs: 0
     * @var mixed
     */
    public $Extensions;
    /**
     * Constructor method for UserNeedStructure
     * @uses UserNeedStructure::setMobilityNeed()
     * @uses UserNeedStructure::setPsychosensoryNeed()
     * @uses UserNeedStructure::setMedicalNeed()
     * @uses UserNeedStructure::setEncumbranceNeed()
     * @uses UserNeedStructure::setExcluded()
     * @uses UserNeedStructure::setNeedRanking()
     * @uses UserNeedStructure::setExtensions()
     * @param string $mobilityNeed
     * @param string $psychosensoryNeed
     * @param MedicalNeedEnumeration $medicalNeed
     * @param string $encumbranceNeed
     * @param bool $excluded
     * @param int $needRanking
     * @param mixed $extensions
     */
    public function __construct($mobilityNeed = null, $psychosensoryNeed = null, MedicalNeedEnumeration $medicalNeed = null, $encumbranceNeed = null, $excluded = null, $needRanking = null, $extensions = null)
    {
        $this
            ->setMobilityNeed($mobilityNeed)
            ->setPsychosensoryNeed($psychosensoryNeed)
            ->setMedicalNeed($medicalNeed)
            ->setEncumbranceNeed($encumbranceNeed)
            ->setExcluded($excluded)
            ->setNeedRanking($needRanking)
            ->setExtensions($extensions);
    }
    /**
     * Get MobilityNeed value
     * @return string|null
     */
    public function getMobilityNeed()
    {
        return $this->MobilityNeed;
    }
    /**
     * Set MobilityNeed value
     * @uses \EnumType\MobilityEnumeration::valueIsValid()
     * @uses \EnumType\MobilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mobilityNeed
     * @return \StructType\UserNeedStructure
     */
    public function setMobilityNeed($mobilityNeed = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MobilityEnumeration::valueIsValid($mobilityNeed)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mobilityNeed, implode(', ', \EnumType\MobilityEnumeration::getValidValues())), __LINE__);
        }
        $this->MobilityNeed = $mobilityNeed;
        return $this;
    }
    /**
     * Get PsychosensoryNeed value
     * @return string|null
     */
    public function getPsychosensoryNeed()
    {
        return $this->PsychosensoryNeed;
    }
    /**
     * Set PsychosensoryNeed value
     * @uses \EnumType\PyschosensoryNeedEnumeration::valueIsValid()
     * @uses \EnumType\PyschosensoryNeedEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $psychosensoryNeed
     * @return \StructType\UserNeedStructure
     */
    public function setPsychosensoryNeed($psychosensoryNeed = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PyschosensoryNeedEnumeration::valueIsValid($psychosensoryNeed)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $psychosensoryNeed, implode(', ', \EnumType\PyschosensoryNeedEnumeration::getValidValues())), __LINE__);
        }
        $this->PsychosensoryNeed = $psychosensoryNeed;
        return $this;
    }
    /**
     * Get MedicalNeed value
     * @return MedicalNeedEnumeration|null
     */
    public function getMedicalNeed()
    {
        return $this->MedicalNeed;
    }
    /**
     * Set MedicalNeed value
     * @param MedicalNeedEnumeration $medicalNeed
     * @return \StructType\UserNeedStructure
     */
    public function setMedicalNeed(MedicalNeedEnumeration $medicalNeed = null)
    {
        $this->MedicalNeed = $medicalNeed;
        return $this;
    }
    /**
     * Get EncumbranceNeed value
     * @return string|null
     */
    public function getEncumbranceNeed()
    {
        return $this->EncumbranceNeed;
    }
    /**
     * Set EncumbranceNeed value
     * @uses \EnumType\EncumbranceEnumeration::valueIsValid()
     * @uses \EnumType\EncumbranceEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $encumbranceNeed
     * @return \StructType\UserNeedStructure
     */
    public function setEncumbranceNeed($encumbranceNeed = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EncumbranceEnumeration::valueIsValid($encumbranceNeed)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $encumbranceNeed, implode(', ', \EnumType\EncumbranceEnumeration::getValidValues())), __LINE__);
        }
        $this->EncumbranceNeed = $encumbranceNeed;
        return $this;
    }
    /**
     * Get Excluded value
     * @return bool|null
     */
    public function getExcluded()
    {
        return $this->Excluded;
    }
    /**
     * Set Excluded value
     * @param bool $excluded
     * @return \StructType\UserNeedStructure
     */
    public function setExcluded($excluded = null)
    {
        // validation for constraint: boolean
        if (!is_null($excluded) && !is_bool($excluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($excluded)), __LINE__);
        }
        $this->Excluded = $excluded;
        return $this;
    }
    /**
     * Get NeedRanking value
     * @return int|null
     */
    public function getNeedRanking()
    {
        return $this->NeedRanking;
    }
    /**
     * Set NeedRanking value
     * @param int $needRanking
     * @return \StructType\UserNeedStructure
     */
    public function setNeedRanking($needRanking = null)
    {
        // validation for constraint: int
        if (!is_null($needRanking) && !is_numeric($needRanking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($needRanking)), __LINE__);
        }
        $this->NeedRanking = $needRanking;
        return $this;
    }
    /**
     * Get Extensions value
     * @return mixed|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param mixed $extensions
     * @return \StructType\UserNeedStructure
     */
    public function setExtensions($extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserNeedStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
