<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnknownEndpointErrorStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Error: Unknown Endpoint +SIRI v2.0
 * @subpackage Structs
 */
class UnknownEndpointErrorStructure extends ErrorCodeStructure
{
    /**
     * The Endpoint
     * Meta informations extracted from the WSDL
     * - documentation: Endpoint that is noit known. + SIRI v2.0 | Type for a endpoint.
     * - minOccurs: 0
     * @var string
     */
    public $Endpoint;
    /**
     * Constructor method for UnknownEndpointErrorStructure
     * @uses UnknownEndpointErrorStructure::setEndpoint()
     * @param string $endpoint
     */
    public function __construct($endpoint = null)
    {
        $this
            ->setEndpoint($endpoint);
    }
    /**
     * Get Endpoint value
     * @return string|null
     */
    public function getEndpoint()
    {
        return $this->Endpoint;
    }
    /**
     * Set Endpoint value
     * @param string $endpoint
     * @return \StructType\UnknownEndpointErrorStructure
     */
    public function setEndpoint($endpoint = null)
    {
        // validation for constraint: string
        if (!is_null($endpoint) && !is_string($endpoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endpoint)), __LINE__);
        }
        $this->Endpoint = $endpoint;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnknownEndpointErrorStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
