<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelTimeValue StructType
 * @subpackage Structs
 */
class TravelTimeValue extends BasicDataValue
{
    /**
     * The travelTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $travelTime;
    /**
     * The travelTimeTrendType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $travelTimeTrendType;
    /**
     * The travelTimeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $travelTimeType;
    /**
     * The freeFlowSpeed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $freeFlowSpeed;
    /**
     * The freeFlowTravelTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $freeFlowTravelTime;
    /**
     * The normallyExpectedTravelTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $normallyExpectedTravelTime;
    /**
     * The vehicleType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $vehicleType;
    /**
     * The travelTimeValueExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $travelTimeValueExtension;
    /**
     * Constructor method for TravelTimeValue
     * @uses TravelTimeValue::setTravelTime()
     * @uses TravelTimeValue::setTravelTimeTrendType()
     * @uses TravelTimeValue::setTravelTimeType()
     * @uses TravelTimeValue::setFreeFlowSpeed()
     * @uses TravelTimeValue::setFreeFlowTravelTime()
     * @uses TravelTimeValue::setNormallyExpectedTravelTime()
     * @uses TravelTimeValue::setVehicleType()
     * @uses TravelTimeValue::setTravelTimeValueExtension()
     * @param float $travelTime
     * @param string $travelTimeTrendType
     * @param string $travelTimeType
     * @param float $freeFlowSpeed
     * @param float $freeFlowTravelTime
     * @param float $normallyExpectedTravelTime
     * @param string[] $vehicleType
     * @param \StructType\ExtensionType $travelTimeValueExtension
     */
    public function __construct($travelTime = null, $travelTimeTrendType = null, $travelTimeType = null, $freeFlowSpeed = null, $freeFlowTravelTime = null, $normallyExpectedTravelTime = null, array $vehicleType = array(), \StructType\ExtensionType $travelTimeValueExtension = null)
    {
        $this
            ->setTravelTime($travelTime)
            ->setTravelTimeTrendType($travelTimeTrendType)
            ->setTravelTimeType($travelTimeType)
            ->setFreeFlowSpeed($freeFlowSpeed)
            ->setFreeFlowTravelTime($freeFlowTravelTime)
            ->setNormallyExpectedTravelTime($normallyExpectedTravelTime)
            ->setVehicleType($vehicleType)
            ->setTravelTimeValueExtension($travelTimeValueExtension);
    }
    /**
     * Get travelTime value
     * @return float|null
     */
    public function getTravelTime()
    {
        return $this->travelTime;
    }
    /**
     * Set travelTime value
     * @param float $travelTime
     * @return \StructType\TravelTimeValue
     */
    public function setTravelTime($travelTime = null)
    {
        $this->travelTime = $travelTime;
        return $this;
    }
    /**
     * Get travelTimeTrendType value
     * @return string|null
     */
    public function getTravelTimeTrendType()
    {
        return $this->travelTimeTrendType;
    }
    /**
     * Set travelTimeTrendType value
     * @uses \EnumType\TravelTimeTrendTypeEnum::valueIsValid()
     * @uses \EnumType\TravelTimeTrendTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $travelTimeTrendType
     * @return \StructType\TravelTimeValue
     */
    public function setTravelTimeTrendType($travelTimeTrendType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TravelTimeTrendTypeEnum::valueIsValid($travelTimeTrendType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $travelTimeTrendType, implode(', ', \EnumType\TravelTimeTrendTypeEnum::getValidValues())), __LINE__);
        }
        $this->travelTimeTrendType = $travelTimeTrendType;
        return $this;
    }
    /**
     * Get travelTimeType value
     * @return string|null
     */
    public function getTravelTimeType()
    {
        return $this->travelTimeType;
    }
    /**
     * Set travelTimeType value
     * @uses \EnumType\TravelTimeTypeEnum::valueIsValid()
     * @uses \EnumType\TravelTimeTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $travelTimeType
     * @return \StructType\TravelTimeValue
     */
    public function setTravelTimeType($travelTimeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TravelTimeTypeEnum::valueIsValid($travelTimeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $travelTimeType, implode(', ', \EnumType\TravelTimeTypeEnum::getValidValues())), __LINE__);
        }
        $this->travelTimeType = $travelTimeType;
        return $this;
    }
    /**
     * Get freeFlowSpeed value
     * @return float|null
     */
    public function getFreeFlowSpeed()
    {
        return $this->freeFlowSpeed;
    }
    /**
     * Set freeFlowSpeed value
     * @param float $freeFlowSpeed
     * @return \StructType\TravelTimeValue
     */
    public function setFreeFlowSpeed($freeFlowSpeed = null)
    {
        $this->freeFlowSpeed = $freeFlowSpeed;
        return $this;
    }
    /**
     * Get freeFlowTravelTime value
     * @return float|null
     */
    public function getFreeFlowTravelTime()
    {
        return $this->freeFlowTravelTime;
    }
    /**
     * Set freeFlowTravelTime value
     * @param float $freeFlowTravelTime
     * @return \StructType\TravelTimeValue
     */
    public function setFreeFlowTravelTime($freeFlowTravelTime = null)
    {
        $this->freeFlowTravelTime = $freeFlowTravelTime;
        return $this;
    }
    /**
     * Get normallyExpectedTravelTime value
     * @return float|null
     */
    public function getNormallyExpectedTravelTime()
    {
        return $this->normallyExpectedTravelTime;
    }
    /**
     * Set normallyExpectedTravelTime value
     * @param float $normallyExpectedTravelTime
     * @return \StructType\TravelTimeValue
     */
    public function setNormallyExpectedTravelTime($normallyExpectedTravelTime = null)
    {
        $this->normallyExpectedTravelTime = $normallyExpectedTravelTime;
        return $this;
    }
    /**
     * Get vehicleType value
     * @return string[]|null
     */
    public function getVehicleType()
    {
        return $this->vehicleType;
    }
    /**
     * Set vehicleType value
     * @uses \EnumType\VehicleTypeEnum::valueIsValid()
     * @uses \EnumType\VehicleTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $vehicleType
     * @return \StructType\TravelTimeValue
     */
    public function setVehicleType(array $vehicleType = array())
    {
        $invalidValues = array();
        foreach ($vehicleType as $travelTimeValueVehicleTypeItem) {
            if (!\EnumType\VehicleTypeEnum::valueIsValid($travelTimeValueVehicleTypeItem)) {
                $invalidValues[] = var_export($travelTimeValueVehicleTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\VehicleTypeEnum::getValidValues())), __LINE__);
        }
        $this->vehicleType = $vehicleType;
        return $this;
    }
    /**
     * Add item to vehicleType value
     * @uses \EnumType\VehicleTypeEnum::valueIsValid()
     * @uses \EnumType\VehicleTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TravelTimeValue
     */
    public function addToVehicleType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\VehicleTypeEnum::getValidValues())), __LINE__);
        }
        $this->vehicleType[] = $item;
        return $this;
    }
    /**
     * Get travelTimeValueExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTravelTimeValueExtension()
    {
        return $this->travelTimeValueExtension;
    }
    /**
     * Set travelTimeValueExtension value
     * @param \StructType\ExtensionType $travelTimeValueExtension
     * @return \StructType\TravelTimeValue
     */
    public function setTravelTimeValueExtension(\StructType\ExtensionType $travelTimeValueExtension = null)
    {
        $this->travelTimeValueExtension = $travelTimeValueExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TravelTimeValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
