<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrainBlockPartStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for BLOCK part elements of VEHICLE JOURNEY.
 * @subpackage Structs
 */
class TrainBlockPartStructure extends AbstractStructBase
{
    /**
     * The NumberOfBlockParts
     * Meta informations extracted from the WSDL
     * - documentation: Total number of BLOCK parts making up the train of which this is part.
     * @var int
     */
    public $NumberOfBlockParts;
    /**
     * The TrainPartRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a train BLOCK part.
     * @var \StructType\TrainPartRefStructure
     */
    public $TrainPartRef;
    /**
     * The PositionOfTrainBlockPart
     * Meta informations extracted from the WSDL
     * - documentation: Description of position of Train BLOCK Part within Train to guide passengers where to find it. E.g. 'Front four coaches'.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $PositionOfTrainBlockPart;
    /**
     * Constructor method for TrainBlockPartStructure
     * @uses TrainBlockPartStructure::setNumberOfBlockParts()
     * @uses TrainBlockPartStructure::setTrainPartRef()
     * @uses TrainBlockPartStructure::setPositionOfTrainBlockPart()
     * @param int $numberOfBlockParts
     * @param \StructType\TrainPartRefStructure $trainPartRef
     * @param \StructType\NaturalLanguageStringStructure[] $positionOfTrainBlockPart
     */
    public function __construct($numberOfBlockParts = null, \StructType\TrainPartRefStructure $trainPartRef = null, array $positionOfTrainBlockPart = array())
    {
        $this
            ->setNumberOfBlockParts($numberOfBlockParts)
            ->setTrainPartRef($trainPartRef)
            ->setPositionOfTrainBlockPart($positionOfTrainBlockPart);
    }
    /**
     * Get NumberOfBlockParts value
     * @return int|null
     */
    public function getNumberOfBlockParts()
    {
        return $this->NumberOfBlockParts;
    }
    /**
     * Set NumberOfBlockParts value
     * @param int $numberOfBlockParts
     * @return \StructType\TrainBlockPartStructure
     */
    public function setNumberOfBlockParts($numberOfBlockParts = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfBlockParts) && !is_numeric($numberOfBlockParts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfBlockParts)), __LINE__);
        }
        $this->NumberOfBlockParts = $numberOfBlockParts;
        return $this;
    }
    /**
     * Get TrainPartRef value
     * @return \StructType\TrainPartRefStructure|null
     */
    public function getTrainPartRef()
    {
        return $this->TrainPartRef;
    }
    /**
     * Set TrainPartRef value
     * @param \StructType\TrainPartRefStructure $trainPartRef
     * @return \StructType\TrainBlockPartStructure
     */
    public function setTrainPartRef(\StructType\TrainPartRefStructure $trainPartRef = null)
    {
        $this->TrainPartRef = $trainPartRef;
        return $this;
    }
    /**
     * Get PositionOfTrainBlockPart value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getPositionOfTrainBlockPart()
    {
        return $this->PositionOfTrainBlockPart;
    }
    /**
     * Set PositionOfTrainBlockPart value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $positionOfTrainBlockPart
     * @return \StructType\TrainBlockPartStructure
     */
    public function setPositionOfTrainBlockPart(array $positionOfTrainBlockPart = array())
    {
        foreach ($positionOfTrainBlockPart as $trainBlockPartStructurePositionOfTrainBlockPartItem) {
            // validation for constraint: itemType
            if (!$trainBlockPartStructurePositionOfTrainBlockPartItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The PositionOfTrainBlockPart property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($trainBlockPartStructurePositionOfTrainBlockPartItem) ? get_class($trainBlockPartStructurePositionOfTrainBlockPartItem) : gettype($trainBlockPartStructurePositionOfTrainBlockPartItem)), __LINE__);
            }
        }
        $this->PositionOfTrainBlockPart = $positionOfTrainBlockPart;
        return $this;
    }
    /**
     * Add item to PositionOfTrainBlockPart value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\TrainBlockPartStructure
     */
    public function addToPositionOfTrainBlockPart(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The PositionOfTrainBlockPart property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PositionOfTrainBlockPart[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrainBlockPartStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
