<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TpegFramedPoint StructType
 * @subpackage Structs
 */
class TpegFramedPoint extends TpegPointLocation
{
    /**
     * The tpegFramedPointLocationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tpegFramedPointLocationType;
    /**
     * The framedPoint
     * @var \StructType\TpegNonJunctionPoint
     */
    public $framedPoint;
    /**
     * The to
     * @var \StructType\TpegPoint
     */
    public $to;
    /**
     * The from
     * @var \StructType\TpegPoint
     */
    public $from;
    /**
     * The tpegFramedPointExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $tpegFramedPointExtension;
    /**
     * Constructor method for TpegFramedPoint
     * @uses TpegFramedPoint::setTpegFramedPointLocationType()
     * @uses TpegFramedPoint::setFramedPoint()
     * @uses TpegFramedPoint::setTo()
     * @uses TpegFramedPoint::setFrom()
     * @uses TpegFramedPoint::setTpegFramedPointExtension()
     * @param string $tpegFramedPointLocationType
     * @param \StructType\TpegNonJunctionPoint $framedPoint
     * @param \StructType\TpegPoint $to
     * @param \StructType\TpegPoint $from
     * @param \StructType\ExtensionType $tpegFramedPointExtension
     */
    public function __construct($tpegFramedPointLocationType = null, \StructType\TpegNonJunctionPoint $framedPoint = null, \StructType\TpegPoint $to = null, \StructType\TpegPoint $from = null, \StructType\ExtensionType $tpegFramedPointExtension = null)
    {
        $this
            ->setTpegFramedPointLocationType($tpegFramedPointLocationType)
            ->setFramedPoint($framedPoint)
            ->setTo($to)
            ->setFrom($from)
            ->setTpegFramedPointExtension($tpegFramedPointExtension);
    }
    /**
     * Get tpegFramedPointLocationType value
     * @return string
     */
    public function getTpegFramedPointLocationType()
    {
        return $this->tpegFramedPointLocationType;
    }
    /**
     * Set tpegFramedPointLocationType value
     * @uses \EnumType\TpegLoc01FramedPointLocationSubtypeEnum::valueIsValid()
     * @uses \EnumType\TpegLoc01FramedPointLocationSubtypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tpegFramedPointLocationType
     * @return \StructType\TpegFramedPoint
     */
    public function setTpegFramedPointLocationType($tpegFramedPointLocationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TpegLoc01FramedPointLocationSubtypeEnum::valueIsValid($tpegFramedPointLocationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tpegFramedPointLocationType, implode(', ', \EnumType\TpegLoc01FramedPointLocationSubtypeEnum::getValidValues())), __LINE__);
        }
        $this->tpegFramedPointLocationType = $tpegFramedPointLocationType;
        return $this;
    }
    /**
     * Get framedPoint value
     * @return \StructType\TpegNonJunctionPoint|null
     */
    public function getFramedPoint()
    {
        return $this->framedPoint;
    }
    /**
     * Set framedPoint value
     * @param \StructType\TpegNonJunctionPoint $framedPoint
     * @return \StructType\TpegFramedPoint
     */
    public function setFramedPoint(\StructType\TpegNonJunctionPoint $framedPoint = null)
    {
        $this->framedPoint = $framedPoint;
        return $this;
    }
    /**
     * Get to value
     * @return \StructType\TpegPoint|null
     */
    public function getTo()
    {
        return $this->to;
    }
    /**
     * Set to value
     * @param \StructType\TpegPoint $to
     * @return \StructType\TpegFramedPoint
     */
    public function setTo(\StructType\TpegPoint $to = null)
    {
        $this->to = $to;
        return $this;
    }
    /**
     * Get from value
     * @return \StructType\TpegPoint|null
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param \StructType\TpegPoint $from
     * @return \StructType\TpegFramedPoint
     */
    public function setFrom(\StructType\TpegPoint $from = null)
    {
        $this->from = $from;
        return $this;
    }
    /**
     * Get tpegFramedPointExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTpegFramedPointExtension()
    {
        return $this->tpegFramedPointExtension;
    }
    /**
     * Set tpegFramedPointExtension value
     * @param \StructType\ExtensionType $tpegFramedPointExtension
     * @return \StructType\TpegFramedPoint
     */
    public function setTpegFramedPointExtension(\StructType\ExtensionType $tpegFramedPointExtension = null)
    {
        $this->tpegFramedPointExtension = $tpegFramedPointExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TpegFramedPoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
