<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TpegAreaLocation StructType
 * @subpackage Structs
 */
abstract class TpegAreaLocation extends AbstractStructBase
{
    /**
     * The tpegAreaLocationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tpegAreaLocationType;
    /**
     * The tpegHeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TpegHeight
     */
    public $tpegHeight;
    /**
     * The tpegAreaLocationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $tpegAreaLocationExtension;
    /**
     * Constructor method for TpegAreaLocation
     * @uses TpegAreaLocation::setTpegAreaLocationType()
     * @uses TpegAreaLocation::setTpegHeight()
     * @uses TpegAreaLocation::setTpegAreaLocationExtension()
     * @param string $tpegAreaLocationType
     * @param \StructType\TpegHeight $tpegHeight
     * @param \StructType\ExtensionType $tpegAreaLocationExtension
     */
    public function __construct($tpegAreaLocationType = null, \StructType\TpegHeight $tpegHeight = null, \StructType\ExtensionType $tpegAreaLocationExtension = null)
    {
        $this
            ->setTpegAreaLocationType($tpegAreaLocationType)
            ->setTpegHeight($tpegHeight)
            ->setTpegAreaLocationExtension($tpegAreaLocationExtension);
    }
    /**
     * Get tpegAreaLocationType value
     * @return string
     */
    public function getTpegAreaLocationType()
    {
        return $this->tpegAreaLocationType;
    }
    /**
     * Set tpegAreaLocationType value
     * @uses \EnumType\TpegLoc01AreaLocationSubtypeEnum::valueIsValid()
     * @uses \EnumType\TpegLoc01AreaLocationSubtypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tpegAreaLocationType
     * @return \StructType\TpegAreaLocation
     */
    public function setTpegAreaLocationType($tpegAreaLocationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TpegLoc01AreaLocationSubtypeEnum::valueIsValid($tpegAreaLocationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tpegAreaLocationType, implode(', ', \EnumType\TpegLoc01AreaLocationSubtypeEnum::getValidValues())), __LINE__);
        }
        $this->tpegAreaLocationType = $tpegAreaLocationType;
        return $this;
    }
    /**
     * Get tpegHeight value
     * @return \StructType\TpegHeight|null
     */
    public function getTpegHeight()
    {
        return $this->tpegHeight;
    }
    /**
     * Set tpegHeight value
     * @param \StructType\TpegHeight $tpegHeight
     * @return \StructType\TpegAreaLocation
     */
    public function setTpegHeight(\StructType\TpegHeight $tpegHeight = null)
    {
        $this->tpegHeight = $tpegHeight;
        return $this;
    }
    /**
     * Get tpegAreaLocationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTpegAreaLocationExtension()
    {
        return $this->tpegAreaLocationExtension;
    }
    /**
     * Set tpegAreaLocationExtension value
     * @param \StructType\ExtensionType $tpegAreaLocationExtension
     * @return \StructType\TpegAreaLocation
     */
    public function setTpegAreaLocationExtension(\StructType\ExtensionType $tpegAreaLocationExtension = null)
    {
        $this->tpegAreaLocationExtension = $tpegAreaLocationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TpegAreaLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
