<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimetabledFeederArrivalStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for incoming visit by feeder journey to SERVICE JOURNEY NTERCHANGE
 * @subpackage Structs
 */
class TimetabledFeederArrivalStructure extends AbstractFeederItemStructure
{
    /**
     * The FeederJourney
     * Meta informations extracted from the WSDL
     * - documentation: Information about the feeder journey.
     * @var \StructType\InterchangeJourneyStructure
     */
    public $FeederJourney;
    /**
     * The AimedArrivalTime
     * Meta informations extracted from the WSDL
     * - documentation: Planned arrival time at the connection point.
     * @var string
     */
    public $AimedArrivalTime;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for TimetabledFeederArrivalStructure
     * @uses TimetabledFeederArrivalStructure::setFeederJourney()
     * @uses TimetabledFeederArrivalStructure::setAimedArrivalTime()
     * @uses TimetabledFeederArrivalStructure::setExtensions()
     * @param \StructType\InterchangeJourneyStructure $feederJourney
     * @param string $aimedArrivalTime
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\InterchangeJourneyStructure $feederJourney = null, $aimedArrivalTime = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setFeederJourney($feederJourney)
            ->setAimedArrivalTime($aimedArrivalTime)
            ->setExtensions($extensions);
    }
    /**
     * Get FeederJourney value
     * @return \StructType\InterchangeJourneyStructure|null
     */
    public function getFeederJourney()
    {
        return $this->FeederJourney;
    }
    /**
     * Set FeederJourney value
     * @param \StructType\InterchangeJourneyStructure $feederJourney
     * @return \StructType\TimetabledFeederArrivalStructure
     */
    public function setFeederJourney(\StructType\InterchangeJourneyStructure $feederJourney = null)
    {
        $this->FeederJourney = $feederJourney;
        return $this;
    }
    /**
     * Get AimedArrivalTime value
     * @return string|null
     */
    public function getAimedArrivalTime()
    {
        return $this->AimedArrivalTime;
    }
    /**
     * Set AimedArrivalTime value
     * @param string $aimedArrivalTime
     * @return \StructType\TimetabledFeederArrivalStructure
     */
    public function setAimedArrivalTime($aimedArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedArrivalTime) && !is_string($aimedArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedArrivalTime)), __LINE__);
        }
        $this->AimedArrivalTime = $aimedArrivalTime;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\TimetabledFeederArrivalStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TimetabledFeederArrivalStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
