<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemperatureInformation StructType
 * @subpackage Structs
 */
class TemperatureInformation extends WeatherValue
{
    /**
     * The temperature
     * @var \StructType\Temperature
     */
    public $temperature;
    /**
     * The temperatureInformationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $temperatureInformationExtension;
    /**
     * Constructor method for TemperatureInformation
     * @uses TemperatureInformation::setTemperature()
     * @uses TemperatureInformation::setTemperatureInformationExtension()
     * @param \StructType\Temperature $temperature
     * @param \StructType\ExtensionType $temperatureInformationExtension
     */
    public function __construct(\StructType\Temperature $temperature = null, \StructType\ExtensionType $temperatureInformationExtension = null)
    {
        $this
            ->setTemperature($temperature)
            ->setTemperatureInformationExtension($temperatureInformationExtension);
    }
    /**
     * Get temperature value
     * @return \StructType\Temperature|null
     */
    public function getTemperature()
    {
        return $this->temperature;
    }
    /**
     * Set temperature value
     * @param \StructType\Temperature $temperature
     * @return \StructType\TemperatureInformation
     */
    public function setTemperature(\StructType\Temperature $temperature = null)
    {
        $this->temperature = $temperature;
        return $this;
    }
    /**
     * Get temperatureInformationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTemperatureInformationExtension()
    {
        return $this->temperatureInformationExtension;
    }
    /**
     * Set temperatureInformationExtension value
     * @param \StructType\ExtensionType $temperatureInformationExtension
     * @return \StructType\TemperatureInformation
     */
    public function setTemperatureInformationExtension(\StructType\ExtensionType $temperatureInformationExtension = null)
    {
        $this->temperatureInformationExtension = $temperatureInformationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TemperatureInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
