<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TargetedInterchangeStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Planned Connection between two VEHICLE JOURNEYs.
 * @subpackage Structs
 */
class TargetedInterchangeStructure extends AbstractStructBase
{
    /**
     * The InterchangeCode
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of SERVICE JOURNEY INTERCHANGE. | Type for identifer of a SERVCIE JOURNEY INTERCHANGE.
     * - minOccurs: 0
     * @var string
     */
    public $InterchangeCode;
    /**
     * The DistributorVehicleJourneyRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a (dated) distributor VEHICLE JOURNEY.
     * @var \StructType\DatedVehicleJourneyRefStructure
     */
    public $DistributorVehicleJourneyRef;
    /**
     * The DistributorConnectionLinkRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a physical CONNECTION LINK over which the SERVICE JOURNEY INTERCHANGE takes place.
     * @var \StructType\ConnectionLinkRefStructure
     */
    public $DistributorConnectionLinkRef;
    /**
     * The DistributorConnectionLink
     * Meta informations extracted from the WSDL
     * - documentation: Link to Interchange stop from which the distributor journey departs. If omitted: the distributor journey stop is the same as the feeder journey stop, i.e. that of theh dated call.
     * @var \StructType\ContextualisedConnectionLinkStructure
     */
    public $DistributorConnectionLink;
    /**
     * The DistributorVisitNumber
     * Meta informations extracted from the WSDL
     * - documentation: Sequence of visit to Distributor stop within Distributor JOURNEY PATTERN. | Type for Stop Visit.
     * - minOccurs: 0
     * @var int
     */
    public $DistributorVisitNumber;
    /**
     * The DistributorOrder
     * Meta informations extracted from the WSDL
     * - documentation: For implementations for which Order is not used for VisitNumber, (i.e. if VisitNumberIsOrder is false) then Order can be used to associate the Order as well if useful for translation.
     * - minOccurs: 0
     * @var int
     */
    public $DistributorOrder;
    /**
     * The StaySeated
     * @var bool
     */
    public $StaySeated;
    /**
     * The Guaranteed
     * @var bool
     */
    public $Guaranteed;
    /**
     * The Advertised
     * @var bool
     */
    public $Advertised;
    /**
     * The StandardWaitTime
     * @var string
     */
    public $StandardWaitTime;
    /**
     * The MaximumWaitTime
     * @var string
     */
    public $MaximumWaitTime;
    /**
     * The MaximumAutomaticWaitTime
     * @var string
     */
    public $MaximumAutomaticWaitTime;
    /**
     * The StandardTransferTime
     * @var string
     */
    public $StandardTransferTime;
    /**
     * The MinimumTransferTime
     * @var string
     */
    public $MinimumTransferTime;
    /**
     * The MaximumTransferTime
     * @var string
     */
    public $MaximumTransferTime;
    /**
     * Constructor method for TargetedInterchangeStructure
     * @uses TargetedInterchangeStructure::setInterchangeCode()
     * @uses TargetedInterchangeStructure::setDistributorVehicleJourneyRef()
     * @uses TargetedInterchangeStructure::setDistributorConnectionLinkRef()
     * @uses TargetedInterchangeStructure::setDistributorConnectionLink()
     * @uses TargetedInterchangeStructure::setDistributorVisitNumber()
     * @uses TargetedInterchangeStructure::setDistributorOrder()
     * @uses TargetedInterchangeStructure::setStaySeated()
     * @uses TargetedInterchangeStructure::setGuaranteed()
     * @uses TargetedInterchangeStructure::setAdvertised()
     * @uses TargetedInterchangeStructure::setStandardWaitTime()
     * @uses TargetedInterchangeStructure::setMaximumWaitTime()
     * @uses TargetedInterchangeStructure::setMaximumAutomaticWaitTime()
     * @uses TargetedInterchangeStructure::setStandardTransferTime()
     * @uses TargetedInterchangeStructure::setMinimumTransferTime()
     * @uses TargetedInterchangeStructure::setMaximumTransferTime()
     * @param string $interchangeCode
     * @param \StructType\DatedVehicleJourneyRefStructure $distributorVehicleJourneyRef
     * @param \StructType\ConnectionLinkRefStructure $distributorConnectionLinkRef
     * @param \StructType\ContextualisedConnectionLinkStructure $distributorConnectionLink
     * @param int $distributorVisitNumber
     * @param int $distributorOrder
     * @param bool $staySeated
     * @param bool $guaranteed
     * @param bool $advertised
     * @param string $standardWaitTime
     * @param string $maximumWaitTime
     * @param string $maximumAutomaticWaitTime
     * @param string $standardTransferTime
     * @param string $minimumTransferTime
     * @param string $maximumTransferTime
     */
    public function __construct($interchangeCode = null, \StructType\DatedVehicleJourneyRefStructure $distributorVehicleJourneyRef = null, \StructType\ConnectionLinkRefStructure $distributorConnectionLinkRef = null, \StructType\ContextualisedConnectionLinkStructure $distributorConnectionLink = null, $distributorVisitNumber = null, $distributorOrder = null, $staySeated = null, $guaranteed = null, $advertised = null, $standardWaitTime = null, $maximumWaitTime = null, $maximumAutomaticWaitTime = null, $standardTransferTime = null, $minimumTransferTime = null, $maximumTransferTime = null)
    {
        $this
            ->setInterchangeCode($interchangeCode)
            ->setDistributorVehicleJourneyRef($distributorVehicleJourneyRef)
            ->setDistributorConnectionLinkRef($distributorConnectionLinkRef)
            ->setDistributorConnectionLink($distributorConnectionLink)
            ->setDistributorVisitNumber($distributorVisitNumber)
            ->setDistributorOrder($distributorOrder)
            ->setStaySeated($staySeated)
            ->setGuaranteed($guaranteed)
            ->setAdvertised($advertised)
            ->setStandardWaitTime($standardWaitTime)
            ->setMaximumWaitTime($maximumWaitTime)
            ->setMaximumAutomaticWaitTime($maximumAutomaticWaitTime)
            ->setStandardTransferTime($standardTransferTime)
            ->setMinimumTransferTime($minimumTransferTime)
            ->setMaximumTransferTime($maximumTransferTime);
    }
    /**
     * Get InterchangeCode value
     * @return string|null
     */
    public function getInterchangeCode()
    {
        return $this->InterchangeCode;
    }
    /**
     * Set InterchangeCode value
     * @param string $interchangeCode
     * @return \StructType\TargetedInterchangeStructure
     */
    public function setInterchangeCode($interchangeCode = null)
    {
        // validation for constraint: string
        if (!is_null($interchangeCode) && !is_string($interchangeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($interchangeCode)), __LINE__);
        }
        $this->InterchangeCode = $interchangeCode;
        return $this;
    }
    /**
     * Get DistributorVehicleJourneyRef value
     * @return \StructType\DatedVehicleJourneyRefStructure|null
     */
    public function getDistributorVehicleJourneyRef()
    {
        return $this->DistributorVehicleJourneyRef;
    }
    /**
     * Set DistributorVehicleJourneyRef value
     * @param \StructType\DatedVehicleJourneyRefStructure $distributorVehicleJourneyRef
     * @return \StructType\TargetedInterchangeStructure
     */
    public function setDistributorVehicleJourneyRef(\StructType\DatedVehicleJourneyRefStructure $distributorVehicleJourneyRef = null)
    {
        $this->DistributorVehicleJourneyRef = $distributorVehicleJourneyRef;
        return $this;
    }
    /**
     * Get DistributorConnectionLinkRef value
     * @return \StructType\ConnectionLinkRefStructure|null
     */
    public function getDistributorConnectionLinkRef()
    {
        return $this->DistributorConnectionLinkRef;
    }
    /**
     * Set DistributorConnectionLinkRef value
     * @param \StructType\ConnectionLinkRefStructure $distributorConnectionLinkRef
     * @return \StructType\TargetedInterchangeStructure
     */
    public function setDistributorConnectionLinkRef(\StructType\ConnectionLinkRefStructure $distributorConnectionLinkRef = null)
    {
        $this->DistributorConnectionLinkRef = $distributorConnectionLinkRef;
        return $this;
    }
    /**
     * Get DistributorConnectionLink value
     * @return \StructType\ContextualisedConnectionLinkStructure|null
     */
    public function getDistributorConnectionLink()
    {
        return $this->DistributorConnectionLink;
    }
    /**
     * Set DistributorConnectionLink value
     * @param \StructType\ContextualisedConnectionLinkStructure $distributorConnectionLink
     * @return \StructType\TargetedInterchangeStructure
     */
    public function setDistributorConnectionLink(\StructType\ContextualisedConnectionLinkStructure $distributorConnectionLink = null)
    {
        $this->DistributorConnectionLink = $distributorConnectionLink;
        return $this;
    }
    /**
     * Get DistributorVisitNumber value
     * @return int|null
     */
    public function getDistributorVisitNumber()
    {
        return $this->DistributorVisitNumber;
    }
    /**
     * Set DistributorVisitNumber value
     * @param int $distributorVisitNumber
     * @return \StructType\TargetedInterchangeStructure
     */
    public function setDistributorVisitNumber($distributorVisitNumber = null)
    {
        // validation for constraint: int
        if (!is_null($distributorVisitNumber) && !is_numeric($distributorVisitNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributorVisitNumber)), __LINE__);
        }
        $this->DistributorVisitNumber = $distributorVisitNumber;
        return $this;
    }
    /**
     * Get DistributorOrder value
     * @return int|null
     */
    public function getDistributorOrder()
    {
        return $this->DistributorOrder;
    }
    /**
     * Set DistributorOrder value
     * @param int $distributorOrder
     * @return \StructType\TargetedInterchangeStructure
     */
    public function setDistributorOrder($distributorOrder = null)
    {
        // validation for constraint: int
        if (!is_null($distributorOrder) && !is_numeric($distributorOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributorOrder)), __LINE__);
        }
        $this->DistributorOrder = $distributorOrder;
        return $this;
    }
    /**
     * Get StaySeated value
     * @return bool|null
     */
    public function getStaySeated()
    {
        return $this->StaySeated;
    }
    /**
     * Set StaySeated value
     * @param bool $staySeated
     * @return \StructType\TargetedInterchangeStructure
     */
    public function setStaySeated($staySeated = null)
    {
        // validation for constraint: boolean
        if (!is_null($staySeated) && !is_bool($staySeated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($staySeated)), __LINE__);
        }
        $this->StaySeated = $staySeated;
        return $this;
    }
    /**
     * Get Guaranteed value
     * @return bool|null
     */
    public function getGuaranteed()
    {
        return $this->Guaranteed;
    }
    /**
     * Set Guaranteed value
     * @param bool $guaranteed
     * @return \StructType\TargetedInterchangeStructure
     */
    public function setGuaranteed($guaranteed = null)
    {
        // validation for constraint: boolean
        if (!is_null($guaranteed) && !is_bool($guaranteed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($guaranteed)), __LINE__);
        }
        $this->Guaranteed = $guaranteed;
        return $this;
    }
    /**
     * Get Advertised value
     * @return bool|null
     */
    public function getAdvertised()
    {
        return $this->Advertised;
    }
    /**
     * Set Advertised value
     * @param bool $advertised
     * @return \StructType\TargetedInterchangeStructure
     */
    public function setAdvertised($advertised = null)
    {
        // validation for constraint: boolean
        if (!is_null($advertised) && !is_bool($advertised)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($advertised)), __LINE__);
        }
        $this->Advertised = $advertised;
        return $this;
    }
    /**
     * Get StandardWaitTime value
     * @return string|null
     */
    public function getStandardWaitTime()
    {
        return $this->StandardWaitTime;
    }
    /**
     * Set StandardWaitTime value
     * @param string $standardWaitTime
     * @return \StructType\TargetedInterchangeStructure
     */
    public function setStandardWaitTime($standardWaitTime = null)
    {
        // validation for constraint: string
        if (!is_null($standardWaitTime) && !is_string($standardWaitTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($standardWaitTime)), __LINE__);
        }
        $this->StandardWaitTime = $standardWaitTime;
        return $this;
    }
    /**
     * Get MaximumWaitTime value
     * @return string|null
     */
    public function getMaximumWaitTime()
    {
        return $this->MaximumWaitTime;
    }
    /**
     * Set MaximumWaitTime value
     * @param string $maximumWaitTime
     * @return \StructType\TargetedInterchangeStructure
     */
    public function setMaximumWaitTime($maximumWaitTime = null)
    {
        // validation for constraint: string
        if (!is_null($maximumWaitTime) && !is_string($maximumWaitTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maximumWaitTime)), __LINE__);
        }
        $this->MaximumWaitTime = $maximumWaitTime;
        return $this;
    }
    /**
     * Get MaximumAutomaticWaitTime value
     * @return string|null
     */
    public function getMaximumAutomaticWaitTime()
    {
        return $this->MaximumAutomaticWaitTime;
    }
    /**
     * Set MaximumAutomaticWaitTime value
     * @param string $maximumAutomaticWaitTime
     * @return \StructType\TargetedInterchangeStructure
     */
    public function setMaximumAutomaticWaitTime($maximumAutomaticWaitTime = null)
    {
        // validation for constraint: string
        if (!is_null($maximumAutomaticWaitTime) && !is_string($maximumAutomaticWaitTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maximumAutomaticWaitTime)), __LINE__);
        }
        $this->MaximumAutomaticWaitTime = $maximumAutomaticWaitTime;
        return $this;
    }
    /**
     * Get StandardTransferTime value
     * @return string|null
     */
    public function getStandardTransferTime()
    {
        return $this->StandardTransferTime;
    }
    /**
     * Set StandardTransferTime value
     * @param string $standardTransferTime
     * @return \StructType\TargetedInterchangeStructure
     */
    public function setStandardTransferTime($standardTransferTime = null)
    {
        // validation for constraint: string
        if (!is_null($standardTransferTime) && !is_string($standardTransferTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($standardTransferTime)), __LINE__);
        }
        $this->StandardTransferTime = $standardTransferTime;
        return $this;
    }
    /**
     * Get MinimumTransferTime value
     * @return string|null
     */
    public function getMinimumTransferTime()
    {
        return $this->MinimumTransferTime;
    }
    /**
     * Set MinimumTransferTime value
     * @param string $minimumTransferTime
     * @return \StructType\TargetedInterchangeStructure
     */
    public function setMinimumTransferTime($minimumTransferTime = null)
    {
        // validation for constraint: string
        if (!is_null($minimumTransferTime) && !is_string($minimumTransferTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minimumTransferTime)), __LINE__);
        }
        $this->MinimumTransferTime = $minimumTransferTime;
        return $this;
    }
    /**
     * Get MaximumTransferTime value
     * @return string|null
     */
    public function getMaximumTransferTime()
    {
        return $this->MaximumTransferTime;
    }
    /**
     * Set MaximumTransferTime value
     * @param string $maximumTransferTime
     * @return \StructType\TargetedInterchangeStructure
     */
    public function setMaximumTransferTime($maximumTransferTime = null)
    {
        // validation for constraint: string
        if (!is_null($maximumTransferTime) && !is_string($maximumTransferTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maximumTransferTime)), __LINE__);
        }
        $this->MaximumTransferTime = $maximumTransferTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TargetedInterchangeStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
