<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Target StructType
 * @subpackage Structs
 */
class Target extends AbstractStructBase
{
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $address;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $protocol;
    /**
     * The targetExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $targetExtension;
    /**
     * Constructor method for Target
     * @uses Target::setAddress()
     * @uses Target::setProtocol()
     * @uses Target::setTargetExtension()
     * @param string $address
     * @param string $protocol
     * @param \StructType\ExtensionType $targetExtension
     */
    public function __construct($address = null, $protocol = null, \StructType\ExtensionType $targetExtension = null)
    {
        $this
            ->setAddress($address)
            ->setProtocol($protocol)
            ->setTargetExtension($targetExtension);
    }
    /**
     * Get address value
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\Target
     */
    public function setAddress($address = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($address) && strlen($address) > 1024) || (is_array($address) && count($address) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($address) ? strlen($address) : count($address)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \StructType\Target
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($protocol) && strlen($protocol) > 1024) || (is_array($protocol) && count($protocol) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($protocol) ? strlen($protocol) : count($protocol)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($protocol) && !is_string($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($protocol)), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get targetExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTargetExtension()
    {
        return $this->targetExtension;
    }
    /**
     * Set targetExtension value
     * @param \StructType\ExtensionType $targetExtension
     * @return \StructType\Target
     */
    public function setTargetExtension(\StructType\ExtensionType $targetExtension = null)
    {
        $this->targetExtension = $targetExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Target
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
