<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplementaryPositionalDescription StructType
 * @subpackage Structs
 */
class SupplementaryPositionalDescription extends AbstractStructBase
{
    /**
     * The carriageway
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $carriageway;
    /**
     * The footpath
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $footpath;
    /**
     * The lane
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $lane;
    /**
     * The lengthAffected
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $lengthAffected;
    /**
     * The locationDescriptor
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $locationDescriptor;
    /**
     * The locationPrecision
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $locationPrecision;
    /**
     * The sequentialRampNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $sequentialRampNumber;
    /**
     * The supplementaryPositionalDescriptionExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $supplementaryPositionalDescriptionExtension;
    /**
     * Constructor method for SupplementaryPositionalDescription
     * @uses SupplementaryPositionalDescription::setCarriageway()
     * @uses SupplementaryPositionalDescription::setFootpath()
     * @uses SupplementaryPositionalDescription::setLane()
     * @uses SupplementaryPositionalDescription::setLengthAffected()
     * @uses SupplementaryPositionalDescription::setLocationDescriptor()
     * @uses SupplementaryPositionalDescription::setLocationPrecision()
     * @uses SupplementaryPositionalDescription::setSequentialRampNumber()
     * @uses SupplementaryPositionalDescription::setSupplementaryPositionalDescriptionExtension()
     * @param string[] $carriageway
     * @param bool $footpath
     * @param string[] $lane
     * @param float $lengthAffected
     * @param string[] $locationDescriptor
     * @param int $locationPrecision
     * @param int $sequentialRampNumber
     * @param \StructType\ExtensionType $supplementaryPositionalDescriptionExtension
     */
    public function __construct(array $carriageway = array(), $footpath = null, array $lane = array(), $lengthAffected = null, array $locationDescriptor = array(), $locationPrecision = null, $sequentialRampNumber = null, \StructType\ExtensionType $supplementaryPositionalDescriptionExtension = null)
    {
        $this
            ->setCarriageway($carriageway)
            ->setFootpath($footpath)
            ->setLane($lane)
            ->setLengthAffected($lengthAffected)
            ->setLocationDescriptor($locationDescriptor)
            ->setLocationPrecision($locationPrecision)
            ->setSequentialRampNumber($sequentialRampNumber)
            ->setSupplementaryPositionalDescriptionExtension($supplementaryPositionalDescriptionExtension);
    }
    /**
     * Get carriageway value
     * @return string[]|null
     */
    public function getCarriageway()
    {
        return $this->carriageway;
    }
    /**
     * Set carriageway value
     * @uses \EnumType\CarriagewayEnum::valueIsValid()
     * @uses \EnumType\CarriagewayEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $carriageway
     * @return \StructType\SupplementaryPositionalDescription
     */
    public function setCarriageway(array $carriageway = array())
    {
        $invalidValues = array();
        foreach ($carriageway as $supplementaryPositionalDescriptionCarriagewayItem) {
            if (!\EnumType\CarriagewayEnum::valueIsValid($supplementaryPositionalDescriptionCarriagewayItem)) {
                $invalidValues[] = var_export($supplementaryPositionalDescriptionCarriagewayItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\CarriagewayEnum::getValidValues())), __LINE__);
        }
        $this->carriageway = $carriageway;
        return $this;
    }
    /**
     * Add item to carriageway value
     * @uses \EnumType\CarriagewayEnum::valueIsValid()
     * @uses \EnumType\CarriagewayEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SupplementaryPositionalDescription
     */
    public function addToCarriageway($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CarriagewayEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\CarriagewayEnum::getValidValues())), __LINE__);
        }
        $this->carriageway[] = $item;
        return $this;
    }
    /**
     * Get footpath value
     * @return bool|null
     */
    public function getFootpath()
    {
        return $this->footpath;
    }
    /**
     * Set footpath value
     * @param bool $footpath
     * @return \StructType\SupplementaryPositionalDescription
     */
    public function setFootpath($footpath = null)
    {
        // validation for constraint: boolean
        if (!is_null($footpath) && !is_bool($footpath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($footpath)), __LINE__);
        }
        $this->footpath = $footpath;
        return $this;
    }
    /**
     * Get lane value
     * @return string[]|null
     */
    public function getLane()
    {
        return $this->lane;
    }
    /**
     * Set lane value
     * @uses \EnumType\LaneEnum::valueIsValid()
     * @uses \EnumType\LaneEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $lane
     * @return \StructType\SupplementaryPositionalDescription
     */
    public function setLane(array $lane = array())
    {
        $invalidValues = array();
        foreach ($lane as $supplementaryPositionalDescriptionLaneItem) {
            if (!\EnumType\LaneEnum::valueIsValid($supplementaryPositionalDescriptionLaneItem)) {
                $invalidValues[] = var_export($supplementaryPositionalDescriptionLaneItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\LaneEnum::getValidValues())), __LINE__);
        }
        $this->lane = $lane;
        return $this;
    }
    /**
     * Add item to lane value
     * @uses \EnumType\LaneEnum::valueIsValid()
     * @uses \EnumType\LaneEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SupplementaryPositionalDescription
     */
    public function addToLane($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LaneEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\LaneEnum::getValidValues())), __LINE__);
        }
        $this->lane[] = $item;
        return $this;
    }
    /**
     * Get lengthAffected value
     * @return float|null
     */
    public function getLengthAffected()
    {
        return $this->lengthAffected;
    }
    /**
     * Set lengthAffected value
     * @param float $lengthAffected
     * @return \StructType\SupplementaryPositionalDescription
     */
    public function setLengthAffected($lengthAffected = null)
    {
        $this->lengthAffected = $lengthAffected;
        return $this;
    }
    /**
     * Get locationDescriptor value
     * @return string[]|null
     */
    public function getLocationDescriptor()
    {
        return $this->locationDescriptor;
    }
    /**
     * Set locationDescriptor value
     * @uses \EnumType\LocationDescriptorEnum::valueIsValid()
     * @uses \EnumType\LocationDescriptorEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $locationDescriptor
     * @return \StructType\SupplementaryPositionalDescription
     */
    public function setLocationDescriptor(array $locationDescriptor = array())
    {
        $invalidValues = array();
        foreach ($locationDescriptor as $supplementaryPositionalDescriptionLocationDescriptorItem) {
            if (!\EnumType\LocationDescriptorEnum::valueIsValid($supplementaryPositionalDescriptionLocationDescriptorItem)) {
                $invalidValues[] = var_export($supplementaryPositionalDescriptionLocationDescriptorItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\LocationDescriptorEnum::getValidValues())), __LINE__);
        }
        $this->locationDescriptor = $locationDescriptor;
        return $this;
    }
    /**
     * Add item to locationDescriptor value
     * @uses \EnumType\LocationDescriptorEnum::valueIsValid()
     * @uses \EnumType\LocationDescriptorEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SupplementaryPositionalDescription
     */
    public function addToLocationDescriptor($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LocationDescriptorEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\LocationDescriptorEnum::getValidValues())), __LINE__);
        }
        $this->locationDescriptor[] = $item;
        return $this;
    }
    /**
     * Get locationPrecision value
     * @return int|null
     */
    public function getLocationPrecision()
    {
        return $this->locationPrecision;
    }
    /**
     * Set locationPrecision value
     * @param int $locationPrecision
     * @return \StructType\SupplementaryPositionalDescription
     */
    public function setLocationPrecision($locationPrecision = null)
    {
        // validation for constraint: int
        if (!is_null($locationPrecision) && !is_numeric($locationPrecision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($locationPrecision)), __LINE__);
        }
        $this->locationPrecision = $locationPrecision;
        return $this;
    }
    /**
     * Get sequentialRampNumber value
     * @return int|null
     */
    public function getSequentialRampNumber()
    {
        return $this->sequentialRampNumber;
    }
    /**
     * Set sequentialRampNumber value
     * @param int $sequentialRampNumber
     * @return \StructType\SupplementaryPositionalDescription
     */
    public function setSequentialRampNumber($sequentialRampNumber = null)
    {
        // validation for constraint: int
        if (!is_null($sequentialRampNumber) && !is_numeric($sequentialRampNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequentialRampNumber)), __LINE__);
        }
        $this->sequentialRampNumber = $sequentialRampNumber;
        return $this;
    }
    /**
     * Get supplementaryPositionalDescriptionExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getSupplementaryPositionalDescriptionExtension()
    {
        return $this->supplementaryPositionalDescriptionExtension;
    }
    /**
     * Set supplementaryPositionalDescriptionExtension value
     * @param \StructType\ExtensionType $supplementaryPositionalDescriptionExtension
     * @return \StructType\SupplementaryPositionalDescription
     */
    public function setSupplementaryPositionalDescriptionExtension(\StructType\ExtensionType $supplementaryPositionalDescriptionExtension = null)
    {
        $this->supplementaryPositionalDescriptionExtension = $supplementaryPositionalDescriptionExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SupplementaryPositionalDescription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
