<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Suitabilities StructType
 * Meta informations extracted from the WSDL
 * - documentation: Suitabilities of facility for specific passenger needs. | Effect on different passenger needs. | The Suitability of the component to meet specifc user needs.
 * - minOccurs: 0
 * @subpackage Structs
 */
class Suitabilities extends AbstractStructBase
{
    /**
     * The Suitability
     * Meta informations extracted from the WSDL
     * - documentation: Type of specific need for wich the facility is appropriate. | Effect on a passenger need. | The Suitability of com[onent to meet a specifc user need.
     * - maxOccurs: unbounded
     * @var \StructType\SuitabilityStructure[]
     */
    public $Suitability;
    /**
     * Constructor method for Suitabilities
     * @uses Suitabilities::setSuitability()
     * @param \StructType\SuitabilityStructure[] $suitability
     */
    public function __construct(array $suitability = array())
    {
        $this
            ->setSuitability($suitability);
    }
    /**
     * Get Suitability value
     * @return \StructType\SuitabilityStructure[]|null
     */
    public function getSuitability()
    {
        return $this->Suitability;
    }
    /**
     * Set Suitability value
     * @throws \InvalidArgumentException
     * @param \StructType\SuitabilityStructure[] $suitability
     * @return \StructType\Suitabilities
     */
    public function setSuitability(array $suitability = array())
    {
        foreach ($suitability as $suitabilitiesSuitabilityItem) {
            // validation for constraint: itemType
            if (!$suitabilitiesSuitabilityItem instanceof \StructType\SuitabilityStructure) {
                throw new \InvalidArgumentException(sprintf('The Suitability property can only contain items of \StructType\SuitabilityStructure, "%s" given', is_object($suitabilitiesSuitabilityItem) ? get_class($suitabilitiesSuitabilityItem) : gettype($suitabilitiesSuitabilityItem)), __LINE__);
            }
        }
        $this->Suitability = $suitability;
        return $this;
    }
    /**
     * Add item to Suitability value
     * @throws \InvalidArgumentException
     * @param \StructType\SuitabilityStructure $item
     * @return \StructType\Suitabilities
     */
    public function addToSuitability(\StructType\SuitabilityStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SuitabilityStructure) {
            throw new \InvalidArgumentException(sprintf('The Suitability property can only contain items of \StructType\SuitabilityStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Suitability[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Suitabilities
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
