<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscriptionTerminatedNotificationStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Notification to terminate a subscription or subscriptions.
 * @subpackage Structs
 */
class SubscriptionTerminatedNotificationStructure extends ProducerResponseStructure
{
    /**
     * The SubscriberRef
     * @var \StructType\ParticipantRefStructure
     */
    public $SubscriberRef;
    /**
     * The SubscriptionFilterRef
     * @var \StructType\SubscriptionFilterRefStructure
     */
    public $SubscriptionFilterRef;
    /**
     * The SubscriptionRef
     * @var \StructType\SubscriptionQualifierStructure
     */
    public $SubscriptionRef;
    /**
     * The ErrrorCondition
     * Meta informations extracted from the WSDL
     * - documentation: Text description providing additional information about the reason for the subscription termination.
     * - minOccurs: 0
     * @var \StructType\ErrorConditionStructure
     */
    public $ErrrorCondition;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for SubscriptionTerminatedNotificationStructure
     * @uses SubscriptionTerminatedNotificationStructure::setSubscriberRef()
     * @uses SubscriptionTerminatedNotificationStructure::setSubscriptionFilterRef()
     * @uses SubscriptionTerminatedNotificationStructure::setSubscriptionRef()
     * @uses SubscriptionTerminatedNotificationStructure::setErrrorCondition()
     * @uses SubscriptionTerminatedNotificationStructure::setExtensions()
     * @param \StructType\ParticipantRefStructure $subscriberRef
     * @param \StructType\SubscriptionFilterRefStructure $subscriptionFilterRef
     * @param \StructType\SubscriptionQualifierStructure $subscriptionRef
     * @param \StructType\ErrorConditionStructure $errrorCondition
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\ParticipantRefStructure $subscriberRef = null, \StructType\SubscriptionFilterRefStructure $subscriptionFilterRef = null, \StructType\SubscriptionQualifierStructure $subscriptionRef = null, \StructType\ErrorConditionStructure $errrorCondition = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setSubscriberRef($subscriberRef)
            ->setSubscriptionFilterRef($subscriptionFilterRef)
            ->setSubscriptionRef($subscriptionRef)
            ->setErrrorCondition($errrorCondition)
            ->setExtensions($extensions);
    }
    /**
     * Get SubscriberRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getSubscriberRef()
    {
        return $this->SubscriberRef;
    }
    /**
     * Set SubscriberRef value
     * @param \StructType\ParticipantRefStructure $subscriberRef
     * @return \StructType\SubscriptionTerminatedNotificationStructure
     */
    public function setSubscriberRef(\StructType\ParticipantRefStructure $subscriberRef = null)
    {
        $this->SubscriberRef = $subscriberRef;
        return $this;
    }
    /**
     * Get SubscriptionFilterRef value
     * @return \StructType\SubscriptionFilterRefStructure|null
     */
    public function getSubscriptionFilterRef()
    {
        return $this->SubscriptionFilterRef;
    }
    /**
     * Set SubscriptionFilterRef value
     * @param \StructType\SubscriptionFilterRefStructure $subscriptionFilterRef
     * @return \StructType\SubscriptionTerminatedNotificationStructure
     */
    public function setSubscriptionFilterRef(\StructType\SubscriptionFilterRefStructure $subscriptionFilterRef = null)
    {
        $this->SubscriptionFilterRef = $subscriptionFilterRef;
        return $this;
    }
    /**
     * Get SubscriptionRef value
     * @return \StructType\SubscriptionQualifierStructure|null
     */
    public function getSubscriptionRef()
    {
        return $this->SubscriptionRef;
    }
    /**
     * Set SubscriptionRef value
     * @param \StructType\SubscriptionQualifierStructure $subscriptionRef
     * @return \StructType\SubscriptionTerminatedNotificationStructure
     */
    public function setSubscriptionRef(\StructType\SubscriptionQualifierStructure $subscriptionRef = null)
    {
        $this->SubscriptionRef = $subscriptionRef;
        return $this;
    }
    /**
     * Get ErrrorCondition value
     * @return \StructType\ErrorConditionStructure|null
     */
    public function getErrrorCondition()
    {
        return $this->ErrrorCondition;
    }
    /**
     * Set ErrrorCondition value
     * @param \StructType\ErrorConditionStructure $errrorCondition
     * @return \StructType\SubscriptionTerminatedNotificationStructure
     */
    public function setErrrorCondition(\StructType\ErrorConditionStructure $errrorCondition = null)
    {
        $this->ErrrorCondition = $errrorCondition;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\SubscriptionTerminatedNotificationStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubscriptionTerminatedNotificationStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
