<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscriptionResponseStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Subscription Response.
 * @subpackage Structs
 */
class SubscriptionResponseStructure extends ResponseEndpointStructure
{
    /**
     * The ResponseStatus
     * @var \StructType\StatusResponseStructure
     */
    public $ResponseStatus;
    /**
     * The SubscriptionManagerAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $SubscriptionManagerAddress;
    /**
     * The ServiceStartedTime
     * @var string
     */
    public $ServiceStartedTime;
    /**
     * The Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for SubscriptionResponseStructure
     * @uses SubscriptionResponseStructure::setResponseStatus()
     * @uses SubscriptionResponseStructure::setSubscriptionManagerAddress()
     * @uses SubscriptionResponseStructure::setServiceStartedTime()
     * @uses SubscriptionResponseStructure::setExtensions()
     * @param \StructType\StatusResponseStructure $responseStatus
     * @param string $subscriptionManagerAddress
     * @param string $serviceStartedTime
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\StatusResponseStructure $responseStatus = null, $subscriptionManagerAddress = null, $serviceStartedTime = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setResponseStatus($responseStatus)
            ->setSubscriptionManagerAddress($subscriptionManagerAddress)
            ->setServiceStartedTime($serviceStartedTime)
            ->setExtensions($extensions);
    }
    /**
     * Get ResponseStatus value
     * @return \StructType\StatusResponseStructure|null
     */
    public function getResponseStatus()
    {
        return $this->ResponseStatus;
    }
    /**
     * Set ResponseStatus value
     * @param \StructType\StatusResponseStructure $responseStatus
     * @return \StructType\SubscriptionResponseStructure
     */
    public function setResponseStatus(\StructType\StatusResponseStructure $responseStatus = null)
    {
        $this->ResponseStatus = $responseStatus;
        return $this;
    }
    /**
     * Get SubscriptionManagerAddress value
     * @return string|null
     */
    public function getSubscriptionManagerAddress()
    {
        return $this->SubscriptionManagerAddress;
    }
    /**
     * Set SubscriptionManagerAddress value
     * @param string $subscriptionManagerAddress
     * @return \StructType\SubscriptionResponseStructure
     */
    public function setSubscriptionManagerAddress($subscriptionManagerAddress = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionManagerAddress) && !is_string($subscriptionManagerAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriptionManagerAddress)), __LINE__);
        }
        $this->SubscriptionManagerAddress = $subscriptionManagerAddress;
        return $this;
    }
    /**
     * Get ServiceStartedTime value
     * @return string|null
     */
    public function getServiceStartedTime()
    {
        return $this->ServiceStartedTime;
    }
    /**
     * Set ServiceStartedTime value
     * @param string $serviceStartedTime
     * @return \StructType\SubscriptionResponseStructure
     */
    public function setServiceStartedTime($serviceStartedTime = null)
    {
        // validation for constraint: string
        if (!is_null($serviceStartedTime) && !is_string($serviceStartedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceStartedTime)), __LINE__);
        }
        $this->ServiceStartedTime = $serviceStartedTime;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\SubscriptionResponseStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubscriptionResponseStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
