<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscriptionContextStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Subscription context - Configuration parameters which may be evrriden.
 * @subpackage Structs
 */
class SubscriptionContextStructure extends AbstractStructBase
{
    /**
     * The HeartbeatInterval
     * Meta informations extracted from the WSDL
     * - documentation: Interval for heartbeat. | Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be
     * used. Year should not be used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * - minOccurs: 0
     * @var string
     */
    public $HeartbeatInterval;
    /**
     * Constructor method for SubscriptionContextStructure
     * @uses SubscriptionContextStructure::setHeartbeatInterval()
     * @param string $heartbeatInterval
     */
    public function __construct($heartbeatInterval = null)
    {
        $this
            ->setHeartbeatInterval($heartbeatInterval);
    }
    /**
     * Get HeartbeatInterval value
     * @return string|null
     */
    public function getHeartbeatInterval()
    {
        return $this->HeartbeatInterval;
    }
    /**
     * Set HeartbeatInterval value
     * @param string $heartbeatInterval
     * @return \StructType\SubscriptionContextStructure
     */
    public function setHeartbeatInterval($heartbeatInterval = null)
    {
        // validation for constraint: string
        if (!is_null($heartbeatInterval) && !is_string($heartbeatInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($heartbeatInterval)), __LINE__);
        }
        $this->HeartbeatInterval = $heartbeatInterval;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubscriptionContextStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
