<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subscription StructType
 * @subpackage Structs
 */
class Subscription extends AbstractStructBase
{
    /**
     * The operatingMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $operatingMode;
    /**
     * The subscriptionStartTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subscriptionStartTime;
    /**
     * The subscriptionState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subscriptionState;
    /**
     * The updateMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $updateMethod;
    /**
     * The deleteSubscription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $deleteSubscription;
    /**
     * The deliveryInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $deliveryInterval;
    /**
     * The subscriptionStopTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subscriptionStopTime;
    /**
     * The target
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Target[]
     */
    public $target;
    /**
     * The filterReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FilterReference
     */
    public $filterReference;
    /**
     * The catalogueReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CatalogueReference
     */
    public $catalogueReference;
    /**
     * The subscriptionExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $subscriptionExtension;
    /**
     * Constructor method for Subscription
     * @uses Subscription::setOperatingMode()
     * @uses Subscription::setSubscriptionStartTime()
     * @uses Subscription::setSubscriptionState()
     * @uses Subscription::setUpdateMethod()
     * @uses Subscription::setDeleteSubscription()
     * @uses Subscription::setDeliveryInterval()
     * @uses Subscription::setSubscriptionStopTime()
     * @uses Subscription::setTarget()
     * @uses Subscription::setFilterReference()
     * @uses Subscription::setCatalogueReference()
     * @uses Subscription::setSubscriptionExtension()
     * @param string $operatingMode
     * @param string $subscriptionStartTime
     * @param string $subscriptionState
     * @param string $updateMethod
     * @param bool $deleteSubscription
     * @param float $deliveryInterval
     * @param string $subscriptionStopTime
     * @param \StructType\Target[] $target
     * @param \StructType\FilterReference $filterReference
     * @param \StructType\CatalogueReference $catalogueReference
     * @param \StructType\ExtensionType $subscriptionExtension
     */
    public function __construct($operatingMode = null, $subscriptionStartTime = null, $subscriptionState = null, $updateMethod = null, $deleteSubscription = null, $deliveryInterval = null, $subscriptionStopTime = null, array $target = array(), \StructType\FilterReference $filterReference = null, \StructType\CatalogueReference $catalogueReference = null, \StructType\ExtensionType $subscriptionExtension = null)
    {
        $this
            ->setOperatingMode($operatingMode)
            ->setSubscriptionStartTime($subscriptionStartTime)
            ->setSubscriptionState($subscriptionState)
            ->setUpdateMethod($updateMethod)
            ->setDeleteSubscription($deleteSubscription)
            ->setDeliveryInterval($deliveryInterval)
            ->setSubscriptionStopTime($subscriptionStopTime)
            ->setTarget($target)
            ->setFilterReference($filterReference)
            ->setCatalogueReference($catalogueReference)
            ->setSubscriptionExtension($subscriptionExtension);
    }
    /**
     * Get operatingMode value
     * @return string
     */
    public function getOperatingMode()
    {
        return $this->operatingMode;
    }
    /**
     * Set operatingMode value
     * @uses \EnumType\OperatingModeEnum::valueIsValid()
     * @uses \EnumType\OperatingModeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operatingMode
     * @return \StructType\Subscription
     */
    public function setOperatingMode($operatingMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OperatingModeEnum::valueIsValid($operatingMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $operatingMode, implode(', ', \EnumType\OperatingModeEnum::getValidValues())), __LINE__);
        }
        $this->operatingMode = $operatingMode;
        return $this;
    }
    /**
     * Get subscriptionStartTime value
     * @return string
     */
    public function getSubscriptionStartTime()
    {
        return $this->subscriptionStartTime;
    }
    /**
     * Set subscriptionStartTime value
     * @param string $subscriptionStartTime
     * @return \StructType\Subscription
     */
    public function setSubscriptionStartTime($subscriptionStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionStartTime) && !is_string($subscriptionStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriptionStartTime)), __LINE__);
        }
        $this->subscriptionStartTime = $subscriptionStartTime;
        return $this;
    }
    /**
     * Get subscriptionState value
     * @return string
     */
    public function getSubscriptionState()
    {
        return $this->subscriptionState;
    }
    /**
     * Set subscriptionState value
     * @uses \EnumType\SubscriptionStateEnum::valueIsValid()
     * @uses \EnumType\SubscriptionStateEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriptionState
     * @return \StructType\Subscription
     */
    public function setSubscriptionState($subscriptionState = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SubscriptionStateEnum::valueIsValid($subscriptionState)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subscriptionState, implode(', ', \EnumType\SubscriptionStateEnum::getValidValues())), __LINE__);
        }
        $this->subscriptionState = $subscriptionState;
        return $this;
    }
    /**
     * Get updateMethod value
     * @return string
     */
    public function getUpdateMethod()
    {
        return $this->updateMethod;
    }
    /**
     * Set updateMethod value
     * @uses \EnumType\UpdateMethodEnum::valueIsValid()
     * @uses \EnumType\UpdateMethodEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $updateMethod
     * @return \StructType\Subscription
     */
    public function setUpdateMethod($updateMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UpdateMethodEnum::valueIsValid($updateMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $updateMethod, implode(', ', \EnumType\UpdateMethodEnum::getValidValues())), __LINE__);
        }
        $this->updateMethod = $updateMethod;
        return $this;
    }
    /**
     * Get deleteSubscription value
     * @return bool|null
     */
    public function getDeleteSubscription()
    {
        return $this->deleteSubscription;
    }
    /**
     * Set deleteSubscription value
     * @param bool $deleteSubscription
     * @return \StructType\Subscription
     */
    public function setDeleteSubscription($deleteSubscription = null)
    {
        // validation for constraint: boolean
        if (!is_null($deleteSubscription) && !is_bool($deleteSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($deleteSubscription)), __LINE__);
        }
        $this->deleteSubscription = $deleteSubscription;
        return $this;
    }
    /**
     * Get deliveryInterval value
     * @return float|null
     */
    public function getDeliveryInterval()
    {
        return $this->deliveryInterval;
    }
    /**
     * Set deliveryInterval value
     * @param float $deliveryInterval
     * @return \StructType\Subscription
     */
    public function setDeliveryInterval($deliveryInterval = null)
    {
        $this->deliveryInterval = $deliveryInterval;
        return $this;
    }
    /**
     * Get subscriptionStopTime value
     * @return string|null
     */
    public function getSubscriptionStopTime()
    {
        return $this->subscriptionStopTime;
    }
    /**
     * Set subscriptionStopTime value
     * @param string $subscriptionStopTime
     * @return \StructType\Subscription
     */
    public function setSubscriptionStopTime($subscriptionStopTime = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionStopTime) && !is_string($subscriptionStopTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriptionStopTime)), __LINE__);
        }
        $this->subscriptionStopTime = $subscriptionStopTime;
        return $this;
    }
    /**
     * Get target value
     * @return \StructType\Target[]|null
     */
    public function getTarget()
    {
        return $this->target;
    }
    /**
     * Set target value
     * @throws \InvalidArgumentException
     * @param \StructType\Target[] $target
     * @return \StructType\Subscription
     */
    public function setTarget(array $target = array())
    {
        foreach ($target as $subscriptionTargetItem) {
            // validation for constraint: itemType
            if (!$subscriptionTargetItem instanceof \StructType\Target) {
                throw new \InvalidArgumentException(sprintf('The target property can only contain items of \StructType\Target, "%s" given', is_object($subscriptionTargetItem) ? get_class($subscriptionTargetItem) : gettype($subscriptionTargetItem)), __LINE__);
            }
        }
        $this->target = $target;
        return $this;
    }
    /**
     * Add item to target value
     * @throws \InvalidArgumentException
     * @param \StructType\Target $item
     * @return \StructType\Subscription
     */
    public function addToTarget(\StructType\Target $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Target) {
            throw new \InvalidArgumentException(sprintf('The target property can only contain items of \StructType\Target, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->target[] = $item;
        return $this;
    }
    /**
     * Get filterReference value
     * @return \StructType\FilterReference|null
     */
    public function getFilterReference()
    {
        return $this->filterReference;
    }
    /**
     * Set filterReference value
     * @param \StructType\FilterReference $filterReference
     * @return \StructType\Subscription
     */
    public function setFilterReference(\StructType\FilterReference $filterReference = null)
    {
        $this->filterReference = $filterReference;
        return $this;
    }
    /**
     * Get catalogueReference value
     * @return \StructType\CatalogueReference|null
     */
    public function getCatalogueReference()
    {
        return $this->catalogueReference;
    }
    /**
     * Set catalogueReference value
     * @param \StructType\CatalogueReference $catalogueReference
     * @return \StructType\Subscription
     */
    public function setCatalogueReference(\StructType\CatalogueReference $catalogueReference = null)
    {
        $this->catalogueReference = $catalogueReference;
        return $this;
    }
    /**
     * Get subscriptionExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getSubscriptionExtension()
    {
        return $this->subscriptionExtension;
    }
    /**
     * Set subscriptionExtension value
     * @param \StructType\ExtensionType $subscriptionExtension
     * @return \StructType\Subscription
     */
    public function setSubscriptionExtension(\StructType\ExtensionType $subscriptionExtension = null)
    {
        $this->subscriptionExtension = $subscriptionExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Subscription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
