<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopTimetableDeliveryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Data type Delivery for Stop Timetable Service.
 * @subpackage Structs
 */
class StopTimetableDeliveryStructure extends AbstractServiceDeliveryStructure
{
    /**
     * The TimetabledStopVisit
     * @var \StructType\TimetabledStopVisitStructure
     */
    public $TimetabledStopVisit;
    /**
     * The TimetabledStopVisitCancellation
     * @var \StructType\TimetabledStopVisitCancellationStructure
     */
    public $TimetabledStopVisitCancellation;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for StopTimetableDeliveryStructure
     * @uses StopTimetableDeliveryStructure::setTimetabledStopVisit()
     * @uses StopTimetableDeliveryStructure::setTimetabledStopVisitCancellation()
     * @uses StopTimetableDeliveryStructure::setExtensions()
     * @uses StopTimetableDeliveryStructure::setVersion()
     * @param \StructType\TimetabledStopVisitStructure $timetabledStopVisit
     * @param \StructType\TimetabledStopVisitCancellationStructure $timetabledStopVisitCancellation
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\TimetabledStopVisitStructure $timetabledStopVisit = null, \StructType\TimetabledStopVisitCancellationStructure $timetabledStopVisitCancellation = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setTimetabledStopVisit($timetabledStopVisit)
            ->setTimetabledStopVisitCancellation($timetabledStopVisitCancellation)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get TimetabledStopVisit value
     * @return \StructType\TimetabledStopVisitStructure|null
     */
    public function getTimetabledStopVisit()
    {
        return $this->TimetabledStopVisit;
    }
    /**
     * Set TimetabledStopVisit value
     * @param \StructType\TimetabledStopVisitStructure $timetabledStopVisit
     * @return \StructType\StopTimetableDeliveryStructure
     */
    public function setTimetabledStopVisit(\StructType\TimetabledStopVisitStructure $timetabledStopVisit = null)
    {
        $this->TimetabledStopVisit = $timetabledStopVisit;
        return $this;
    }
    /**
     * Get TimetabledStopVisitCancellation value
     * @return \StructType\TimetabledStopVisitCancellationStructure|null
     */
    public function getTimetabledStopVisitCancellation()
    {
        return $this->TimetabledStopVisitCancellation;
    }
    /**
     * Set TimetabledStopVisitCancellation value
     * @param \StructType\TimetabledStopVisitCancellationStructure $timetabledStopVisitCancellation
     * @return \StructType\StopTimetableDeliveryStructure
     */
    public function setTimetabledStopVisitCancellation(\StructType\TimetabledStopVisitCancellationStructure $timetabledStopVisitCancellation = null)
    {
        $this->TimetabledStopVisitCancellation = $timetabledStopVisitCancellation;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\StopTimetableDeliveryStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\StopTimetableDeliveryStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopTimetableDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
