<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopPointsDiscoveryRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Requests for stop reference data for use in service requests. | Parameters that specify the content to be returned. (+SIRI v2.0) | Parameters that affect the request processing. Mostly act to reduce the number of stops returned.
 * (+SIRI v2.0)
 * @subpackage Structs
 */
class StopPointsDiscoveryRequestStructure extends AbstractDiscoveryRequestStructure
{
    /**
     * The BoundingBox
     * @var \StructType\BoundingBoxStructure
     */
    public $BoundingBox;
    /**
     * The Circle
     * @var \StructType\LocationStructure
     */
    public $Circle;
    /**
     * The PlaceRef
     * @var string
     */
    public $PlaceRef;
    /**
     * The OperatorRef
     * @var \StructType\OperatorRefStructure
     */
    public $OperatorRef;
    /**
     * The LineRef
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The StopPointsDetailLevel
     * @var string
     */
    public $StopPointsDetailLevel;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of request. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for StopPointsDiscoveryRequestStructure
     * @uses StopPointsDiscoveryRequestStructure::setBoundingBox()
     * @uses StopPointsDiscoveryRequestStructure::setCircle()
     * @uses StopPointsDiscoveryRequestStructure::setPlaceRef()
     * @uses StopPointsDiscoveryRequestStructure::setOperatorRef()
     * @uses StopPointsDiscoveryRequestStructure::setLineRef()
     * @uses StopPointsDiscoveryRequestStructure::setLanguage()
     * @uses StopPointsDiscoveryRequestStructure::setStopPointsDetailLevel()
     * @uses StopPointsDiscoveryRequestStructure::setExtensions()
     * @uses StopPointsDiscoveryRequestStructure::setVersion()
     * @param \StructType\BoundingBoxStructure $boundingBox
     * @param \StructType\LocationStructure $circle
     * @param string $placeRef
     * @param \StructType\OperatorRefStructure $operatorRef
     * @param \StructType\LineRefStructure $lineRef
     * @param string $language
     * @param string $stopPointsDetailLevel
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\BoundingBoxStructure $boundingBox = null, \StructType\LocationStructure $circle = null, $placeRef = null, \StructType\OperatorRefStructure $operatorRef = null, \StructType\LineRefStructure $lineRef = null, $language = null, $stopPointsDetailLevel = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setBoundingBox($boundingBox)
            ->setCircle($circle)
            ->setPlaceRef($placeRef)
            ->setOperatorRef($operatorRef)
            ->setLineRef($lineRef)
            ->setLanguage($language)
            ->setStopPointsDetailLevel($stopPointsDetailLevel)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get BoundingBox value
     * @return \StructType\BoundingBoxStructure|null
     */
    public function getBoundingBox()
    {
        return $this->BoundingBox;
    }
    /**
     * Set BoundingBox value
     * @param \StructType\BoundingBoxStructure $boundingBox
     * @return \StructType\StopPointsDiscoveryRequestStructure
     */
    public function setBoundingBox(\StructType\BoundingBoxStructure $boundingBox = null)
    {
        $this->BoundingBox = $boundingBox;
        return $this;
    }
    /**
     * Get Circle value
     * @return \StructType\LocationStructure|null
     */
    public function getCircle()
    {
        return $this->Circle;
    }
    /**
     * Set Circle value
     * @param \StructType\LocationStructure $circle
     * @return \StructType\StopPointsDiscoveryRequestStructure
     */
    public function setCircle(\StructType\LocationStructure $circle = null)
    {
        $this->Circle = $circle;
        return $this;
    }
    /**
     * Get PlaceRef value
     * @return string|null
     */
    public function getPlaceRef()
    {
        return $this->PlaceRef;
    }
    /**
     * Set PlaceRef value
     * @param string $placeRef
     * @return \StructType\StopPointsDiscoveryRequestStructure
     */
    public function setPlaceRef($placeRef = null)
    {
        // validation for constraint: string
        if (!is_null($placeRef) && !is_string($placeRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeRef)), __LINE__);
        }
        $this->PlaceRef = $placeRef;
        return $this;
    }
    /**
     * Get OperatorRef value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getOperatorRef()
    {
        return $this->OperatorRef;
    }
    /**
     * Set OperatorRef value
     * @param \StructType\OperatorRefStructure $operatorRef
     * @return \StructType\StopPointsDiscoveryRequestStructure
     */
    public function setOperatorRef(\StructType\OperatorRefStructure $operatorRef = null)
    {
        $this->OperatorRef = $operatorRef;
        return $this;
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\StopPointsDiscoveryRequestStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\StopPointsDiscoveryRequestStructure
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get StopPointsDetailLevel value
     * @return string|null
     */
    public function getStopPointsDetailLevel()
    {
        return $this->StopPointsDetailLevel;
    }
    /**
     * Set StopPointsDetailLevel value
     * @uses \EnumType\StopPointsDetailEnumeration::valueIsValid()
     * @uses \EnumType\StopPointsDetailEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stopPointsDetailLevel
     * @return \StructType\StopPointsDiscoveryRequestStructure
     */
    public function setStopPointsDetailLevel($stopPointsDetailLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StopPointsDetailEnumeration::valueIsValid($stopPointsDetailLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stopPointsDetailLevel, implode(', ', \EnumType\StopPointsDetailEnumeration::getValidValues())), __LINE__);
        }
        $this->StopPointsDetailLevel = $stopPointsDetailLevel;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\StopPointsDiscoveryRequestStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\StopPointsDiscoveryRequestStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopPointsDiscoveryRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
