<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopPoints StructType
 * Meta informations extracted from the WSDL
 * - documentation: STOP POINTs affected by SITUATION. | Stop Poins of the ROUTE. Can be either all or only affected by SITUATION.
 * @subpackage Structs
 */
class StopPoints extends AbstractStructBase
{
    /**
     * The AffectedOnly
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Indicates whether the list of STOP POINTS contains all STOP POINTS of ROUTE or only affected by SITUATION.
     * - minOccurs: 0
     * @var bool
     */
    public $AffectedOnly;
    /**
     * The AffectedStopPoint
     * Meta informations extracted from the WSDL
     * - documentation: Stop affected by SITUATION. | Stop Point of the ROUTE
     * - maxOccurs: unbounded
     * @var \StructType\AffectedStopPointStructure
     */
    public $AffectedStopPoint;
    /**
     * The LinkProjectionToNextStopPoint
     * Meta informations extracted from the WSDL
     * - documentation: GIs projection of Link to the next provided StopPoint. NB Line here means Geometry Polyline, not Transmodel Transport Line.
     * - minOccurs: 0
     * @var \StructType\LinkProjectionStructure
     */
    public $LinkProjectionToNextStopPoint;
    /**
     * Constructor method for StopPoints
     * @uses StopPoints::setAffectedOnly()
     * @uses StopPoints::setAffectedStopPoint()
     * @uses StopPoints::setLinkProjectionToNextStopPoint()
     * @param bool $affectedOnly
     * @param \StructType\AffectedStopPointStructure $affectedStopPoint
     * @param \StructType\LinkProjectionStructure $linkProjectionToNextStopPoint
     */
    public function __construct($affectedOnly = false, \StructType\AffectedStopPointStructure $affectedStopPoint = null, \StructType\LinkProjectionStructure $linkProjectionToNextStopPoint = null)
    {
        $this
            ->setAffectedOnly($affectedOnly)
            ->setAffectedStopPoint($affectedStopPoint)
            ->setLinkProjectionToNextStopPoint($linkProjectionToNextStopPoint);
    }
    /**
     * Get AffectedOnly value
     * @return bool|null
     */
    public function getAffectedOnly()
    {
        return $this->AffectedOnly;
    }
    /**
     * Set AffectedOnly value
     * @param bool $affectedOnly
     * @return \StructType\StopPoints
     */
    public function setAffectedOnly($affectedOnly = false)
    {
        // validation for constraint: boolean
        if (!is_null($affectedOnly) && !is_bool($affectedOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($affectedOnly)), __LINE__);
        }
        $this->AffectedOnly = $affectedOnly;
        return $this;
    }
    /**
     * Get AffectedStopPoint value
     * @return \StructType\AffectedStopPointStructure|null
     */
    public function getAffectedStopPoint()
    {
        return $this->AffectedStopPoint;
    }
    /**
     * Set AffectedStopPoint value
     * @param \StructType\AffectedStopPointStructure $affectedStopPoint
     * @return \StructType\StopPoints
     */
    public function setAffectedStopPoint(\StructType\AffectedStopPointStructure $affectedStopPoint = null)
    {
        $this->AffectedStopPoint = $affectedStopPoint;
        return $this;
    }
    /**
     * Get LinkProjectionToNextStopPoint value
     * @return \StructType\LinkProjectionStructure|null
     */
    public function getLinkProjectionToNextStopPoint()
    {
        return $this->LinkProjectionToNextStopPoint;
    }
    /**
     * Set LinkProjectionToNextStopPoint value
     * @param \StructType\LinkProjectionStructure $linkProjectionToNextStopPoint
     * @return \StructType\StopPoints
     */
    public function setLinkProjectionToNextStopPoint(\StructType\LinkProjectionStructure $linkProjectionToNextStopPoint = null)
    {
        $this->LinkProjectionToNextStopPoint = $linkProjectionToNextStopPoint;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopPoints
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
