<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopPointInPatternStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Summary information about a stop within line
 * @subpackage Structs
 */
class StopPointInPatternStructure extends AnnotatedStopPointStructure
{
    /**
     * The Order
     * Meta informations extracted from the WSDL
     * - documentation: Order of STOP POINT in route +SIRI v2.0
     * @var int
     */
    public $Order;
    /**
     * The OnwardLinkShape
     * Meta informations extracted from the WSDL
     * - documentation: Plot of points from this stop to next Stop. Detail level is 'full'. +SIRI v2.0
     * - minOccurs: 0
     * @var \StructType\LineShapeStructure
     */
    public $OnwardLinkShape;
    /**
     * The LinkProjectionToNextStopPoint
     * Meta informations extracted from the WSDL
     * - documentation: GIs projection of Link to the next provided StopPoint. NB Line here means Geometry Polyline, not Transmodel Transport Line.
     * - minOccurs: 0
     * @var \StructType\LinkProjectionStructure
     */
    public $LinkProjectionToNextStopPoint;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for StopPointInPatternStructure
     * @uses StopPointInPatternStructure::setOrder()
     * @uses StopPointInPatternStructure::setOnwardLinkShape()
     * @uses StopPointInPatternStructure::setLinkProjectionToNextStopPoint()
     * @uses StopPointInPatternStructure::setExtensions()
     * @param int $order
     * @param \StructType\LineShapeStructure $onwardLinkShape
     * @param \StructType\LinkProjectionStructure $linkProjectionToNextStopPoint
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($order = null, \StructType\LineShapeStructure $onwardLinkShape = null, \StructType\LinkProjectionStructure $linkProjectionToNextStopPoint = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setOrder($order)
            ->setOnwardLinkShape($onwardLinkShape)
            ->setLinkProjectionToNextStopPoint($linkProjectionToNextStopPoint)
            ->setExtensions($extensions);
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\StopPointInPatternStructure
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get OnwardLinkShape value
     * @return \StructType\LineShapeStructure|null
     */
    public function getOnwardLinkShape()
    {
        return $this->OnwardLinkShape;
    }
    /**
     * Set OnwardLinkShape value
     * @param \StructType\LineShapeStructure $onwardLinkShape
     * @return \StructType\StopPointInPatternStructure
     */
    public function setOnwardLinkShape(\StructType\LineShapeStructure $onwardLinkShape = null)
    {
        $this->OnwardLinkShape = $onwardLinkShape;
        return $this;
    }
    /**
     * Get LinkProjectionToNextStopPoint value
     * @return \StructType\LinkProjectionStructure|null
     */
    public function getLinkProjectionToNextStopPoint()
    {
        return $this->LinkProjectionToNextStopPoint;
    }
    /**
     * Set LinkProjectionToNextStopPoint value
     * @param \StructType\LinkProjectionStructure $linkProjectionToNextStopPoint
     * @return \StructType\StopPointInPatternStructure
     */
    public function setLinkProjectionToNextStopPoint(\StructType\LinkProjectionStructure $linkProjectionToNextStopPoint = null)
    {
        $this->LinkProjectionToNextStopPoint = $linkProjectionToNextStopPoint;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\StopPointInPatternStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopPointInPatternStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
