<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopPlaces StructType
 * Meta informations extracted from the WSDL
 * - documentation: Places other than STOP POINTs affected by SITUATION.
 * @subpackage Structs
 */
class StopPlaces extends AbstractStructBase
{
    /**
     * The AffectedStopPlace
     * Meta informations extracted from the WSDL
     * - documentation: Stop affected by SITUATION.
     * - maxOccurs: unbounded
     * @var \StructType\AffectedStopPlaceStructure[]
     */
    public $AffectedStopPlace;
    /**
     * Constructor method for StopPlaces
     * @uses StopPlaces::setAffectedStopPlace()
     * @param \StructType\AffectedStopPlaceStructure[] $affectedStopPlace
     */
    public function __construct(array $affectedStopPlace = array())
    {
        $this
            ->setAffectedStopPlace($affectedStopPlace);
    }
    /**
     * Get AffectedStopPlace value
     * @return \StructType\AffectedStopPlaceStructure[]|null
     */
    public function getAffectedStopPlace()
    {
        return $this->AffectedStopPlace;
    }
    /**
     * Set AffectedStopPlace value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedStopPlaceStructure[] $affectedStopPlace
     * @return \StructType\StopPlaces
     */
    public function setAffectedStopPlace(array $affectedStopPlace = array())
    {
        foreach ($affectedStopPlace as $stopPlacesAffectedStopPlaceItem) {
            // validation for constraint: itemType
            if (!$stopPlacesAffectedStopPlaceItem instanceof \StructType\AffectedStopPlaceStructure) {
                throw new \InvalidArgumentException(sprintf('The AffectedStopPlace property can only contain items of \StructType\AffectedStopPlaceStructure, "%s" given', is_object($stopPlacesAffectedStopPlaceItem) ? get_class($stopPlacesAffectedStopPlaceItem) : gettype($stopPlacesAffectedStopPlaceItem)), __LINE__);
            }
        }
        $this->AffectedStopPlace = $affectedStopPlace;
        return $this;
    }
    /**
     * Add item to AffectedStopPlace value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedStopPlaceStructure $item
     * @return \StructType\StopPlaces
     */
    public function addToAffectedStopPlace(\StructType\AffectedStopPlaceStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedStopPlaceStructure) {
            throw new \InvalidArgumentException(sprintf('The AffectedStopPlace property can only contain items of \StructType\AffectedStopPlaceStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AffectedStopPlace[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopPlaces
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
