<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopMonitoringRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Functional Service Request for Stop Monitoring Service.
 * @subpackage Structs
 */
class StopMonitoringRequestStructure extends AbstractFunctionalServiceRequestStructure
{
    /**
     * The PreviewInterval
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $PreviewInterval;
    /**
     * The StartTime
     * @var string
     */
    public $StartTime;
    /**
     * The MonitoringRef
     * @var \StructType\MonitoringRefStructure
     */
    public $MonitoringRef;
    /**
     * The OperatorRef
     * @var \StructType\OperatorRefStructure
     */
    public $OperatorRef;
    /**
     * The LineRef
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The DirectionRef
     * @var \StructType\DirectionRefStructure
     */
    public $DirectionRef;
    /**
     * The DestinationRef
     * @var \StructType\DestinationRefStructure
     */
    public $DestinationRef;
    /**
     * The StopVisitTypes
     * @var string
     */
    public $StopVisitTypes;
    /**
     * The Language
     * @var bool
     */
    public $Language;
    /**
     * The IncludeTranslations
     * @var bool
     */
    public $IncludeTranslations;
    /**
     * The MaximumStopVisits
     * @var int
     */
    public $MaximumStopVisits;
    /**
     * The MinimumStopVisitsPerLine
     * @var int
     */
    public $MinimumStopVisitsPerLine;
    /**
     * The MinimumStopVisitsPerLineVia
     * @var int
     */
    public $MinimumStopVisitsPerLineVia;
    /**
     * The MaximumTextLength
     * @var int
     */
    public $MaximumTextLength;
    /**
     * The StopMonitoringDetailLevel
     * @var string
     */
    public $StopMonitoringDetailLevel;
    /**
     * The IncludeSituations
     * @var bool
     */
    public $IncludeSituations;
    /**
     * The MaximumNumberOfCalls
     * @var \StructType\MaximumNumberOfCalls
     */
    public $MaximumNumberOfCalls;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of request. | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for StopMonitoringRequestStructure
     * @uses StopMonitoringRequestStructure::setPreviewInterval()
     * @uses StopMonitoringRequestStructure::setStartTime()
     * @uses StopMonitoringRequestStructure::setMonitoringRef()
     * @uses StopMonitoringRequestStructure::setOperatorRef()
     * @uses StopMonitoringRequestStructure::setLineRef()
     * @uses StopMonitoringRequestStructure::setDirectionRef()
     * @uses StopMonitoringRequestStructure::setDestinationRef()
     * @uses StopMonitoringRequestStructure::setStopVisitTypes()
     * @uses StopMonitoringRequestStructure::setLanguage()
     * @uses StopMonitoringRequestStructure::setIncludeTranslations()
     * @uses StopMonitoringRequestStructure::setMaximumStopVisits()
     * @uses StopMonitoringRequestStructure::setMinimumStopVisitsPerLine()
     * @uses StopMonitoringRequestStructure::setMinimumStopVisitsPerLineVia()
     * @uses StopMonitoringRequestStructure::setMaximumTextLength()
     * @uses StopMonitoringRequestStructure::setStopMonitoringDetailLevel()
     * @uses StopMonitoringRequestStructure::setIncludeSituations()
     * @uses StopMonitoringRequestStructure::setMaximumNumberOfCalls()
     * @uses StopMonitoringRequestStructure::setExtensions()
     * @uses StopMonitoringRequestStructure::setVersion()
     * @param string $previewInterval
     * @param string $startTime
     * @param \StructType\MonitoringRefStructure $monitoringRef
     * @param \StructType\OperatorRefStructure $operatorRef
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\DirectionRefStructure $directionRef
     * @param \StructType\DestinationRefStructure $destinationRef
     * @param string $stopVisitTypes
     * @param bool $language
     * @param bool $includeTranslations
     * @param int $maximumStopVisits
     * @param int $minimumStopVisitsPerLine
     * @param int $minimumStopVisitsPerLineVia
     * @param int $maximumTextLength
     * @param string $stopMonitoringDetailLevel
     * @param bool $includeSituations
     * @param \StructType\MaximumNumberOfCalls $maximumNumberOfCalls
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct($previewInterval = null, $startTime = null, \StructType\MonitoringRefStructure $monitoringRef = null, \StructType\OperatorRefStructure $operatorRef = null, \StructType\LineRefStructure $lineRef = null, \StructType\DirectionRefStructure $directionRef = null, \StructType\DestinationRefStructure $destinationRef = null, $stopVisitTypes = null, $language = null, $includeTranslations = null, $maximumStopVisits = null, $minimumStopVisitsPerLine = null, $minimumStopVisitsPerLineVia = null, $maximumTextLength = null, $stopMonitoringDetailLevel = null, $includeSituations = null, \StructType\MaximumNumberOfCalls $maximumNumberOfCalls = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setPreviewInterval($previewInterval)
            ->setStartTime($startTime)
            ->setMonitoringRef($monitoringRef)
            ->setOperatorRef($operatorRef)
            ->setLineRef($lineRef)
            ->setDirectionRef($directionRef)
            ->setDestinationRef($destinationRef)
            ->setStopVisitTypes($stopVisitTypes)
            ->setLanguage($language)
            ->setIncludeTranslations($includeTranslations)
            ->setMaximumStopVisits($maximumStopVisits)
            ->setMinimumStopVisitsPerLine($minimumStopVisitsPerLine)
            ->setMinimumStopVisitsPerLineVia($minimumStopVisitsPerLineVia)
            ->setMaximumTextLength($maximumTextLength)
            ->setStopMonitoringDetailLevel($stopMonitoringDetailLevel)
            ->setIncludeSituations($includeSituations)
            ->setMaximumNumberOfCalls($maximumNumberOfCalls)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get PreviewInterval value
     * @return string|null
     */
    public function getPreviewInterval()
    {
        return $this->PreviewInterval;
    }
    /**
     * Set PreviewInterval value
     * @param string $previewInterval
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setPreviewInterval($previewInterval = null)
    {
        // validation for constraint: string
        if (!is_null($previewInterval) && !is_string($previewInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($previewInterval)), __LINE__);
        }
        $this->PreviewInterval = $previewInterval;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get MonitoringRef value
     * @return \StructType\MonitoringRefStructure|null
     */
    public function getMonitoringRef()
    {
        return $this->MonitoringRef;
    }
    /**
     * Set MonitoringRef value
     * @param \StructType\MonitoringRefStructure $monitoringRef
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setMonitoringRef(\StructType\MonitoringRefStructure $monitoringRef = null)
    {
        $this->MonitoringRef = $monitoringRef;
        return $this;
    }
    /**
     * Get OperatorRef value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getOperatorRef()
    {
        return $this->OperatorRef;
    }
    /**
     * Set OperatorRef value
     * @param \StructType\OperatorRefStructure $operatorRef
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setOperatorRef(\StructType\OperatorRefStructure $operatorRef = null)
    {
        $this->OperatorRef = $operatorRef;
        return $this;
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get DirectionRef value
     * @return \StructType\DirectionRefStructure|null
     */
    public function getDirectionRef()
    {
        return $this->DirectionRef;
    }
    /**
     * Set DirectionRef value
     * @param \StructType\DirectionRefStructure $directionRef
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setDirectionRef(\StructType\DirectionRefStructure $directionRef = null)
    {
        $this->DirectionRef = $directionRef;
        return $this;
    }
    /**
     * Get DestinationRef value
     * @return \StructType\DestinationRefStructure|null
     */
    public function getDestinationRef()
    {
        return $this->DestinationRef;
    }
    /**
     * Set DestinationRef value
     * @param \StructType\DestinationRefStructure $destinationRef
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setDestinationRef(\StructType\DestinationRefStructure $destinationRef = null)
    {
        $this->DestinationRef = $destinationRef;
        return $this;
    }
    /**
     * Get StopVisitTypes value
     * @return string|null
     */
    public function getStopVisitTypes()
    {
        return $this->StopVisitTypes;
    }
    /**
     * Set StopVisitTypes value
     * @uses \EnumType\StopVisitTypeEnumeration::valueIsValid()
     * @uses \EnumType\StopVisitTypeEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stopVisitTypes
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setStopVisitTypes($stopVisitTypes = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StopVisitTypeEnumeration::valueIsValid($stopVisitTypes)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stopVisitTypes, implode(', ', \EnumType\StopVisitTypeEnumeration::getValidValues())), __LINE__);
        }
        $this->StopVisitTypes = $stopVisitTypes;
        return $this;
    }
    /**
     * Get Language value
     * @return bool|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param bool $language
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: boolean
        if (!is_null($language) && !is_bool($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get IncludeTranslations value
     * @return bool|null
     */
    public function getIncludeTranslations()
    {
        return $this->IncludeTranslations;
    }
    /**
     * Set IncludeTranslations value
     * @param bool $includeTranslations
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setIncludeTranslations($includeTranslations = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTranslations) && !is_bool($includeTranslations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeTranslations)), __LINE__);
        }
        $this->IncludeTranslations = $includeTranslations;
        return $this;
    }
    /**
     * Get MaximumStopVisits value
     * @return int|null
     */
    public function getMaximumStopVisits()
    {
        return $this->MaximumStopVisits;
    }
    /**
     * Set MaximumStopVisits value
     * @param int $maximumStopVisits
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setMaximumStopVisits($maximumStopVisits = null)
    {
        // validation for constraint: int
        if (!is_null($maximumStopVisits) && !is_numeric($maximumStopVisits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumStopVisits)), __LINE__);
        }
        $this->MaximumStopVisits = $maximumStopVisits;
        return $this;
    }
    /**
     * Get MinimumStopVisitsPerLine value
     * @return int|null
     */
    public function getMinimumStopVisitsPerLine()
    {
        return $this->MinimumStopVisitsPerLine;
    }
    /**
     * Set MinimumStopVisitsPerLine value
     * @param int $minimumStopVisitsPerLine
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setMinimumStopVisitsPerLine($minimumStopVisitsPerLine = null)
    {
        // validation for constraint: int
        if (!is_null($minimumStopVisitsPerLine) && !is_numeric($minimumStopVisitsPerLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minimumStopVisitsPerLine)), __LINE__);
        }
        $this->MinimumStopVisitsPerLine = $minimumStopVisitsPerLine;
        return $this;
    }
    /**
     * Get MinimumStopVisitsPerLineVia value
     * @return int|null
     */
    public function getMinimumStopVisitsPerLineVia()
    {
        return $this->MinimumStopVisitsPerLineVia;
    }
    /**
     * Set MinimumStopVisitsPerLineVia value
     * @param int $minimumStopVisitsPerLineVia
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setMinimumStopVisitsPerLineVia($minimumStopVisitsPerLineVia = null)
    {
        // validation for constraint: int
        if (!is_null($minimumStopVisitsPerLineVia) && !is_numeric($minimumStopVisitsPerLineVia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minimumStopVisitsPerLineVia)), __LINE__);
        }
        $this->MinimumStopVisitsPerLineVia = $minimumStopVisitsPerLineVia;
        return $this;
    }
    /**
     * Get MaximumTextLength value
     * @return int|null
     */
    public function getMaximumTextLength()
    {
        return $this->MaximumTextLength;
    }
    /**
     * Set MaximumTextLength value
     * @param int $maximumTextLength
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setMaximumTextLength($maximumTextLength = null)
    {
        // validation for constraint: int
        if (!is_null($maximumTextLength) && !is_numeric($maximumTextLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumTextLength)), __LINE__);
        }
        $this->MaximumTextLength = $maximumTextLength;
        return $this;
    }
    /**
     * Get StopMonitoringDetailLevel value
     * @return string|null
     */
    public function getStopMonitoringDetailLevel()
    {
        return $this->StopMonitoringDetailLevel;
    }
    /**
     * Set StopMonitoringDetailLevel value
     * @uses \EnumType\StopMonitoringDetailEnumeration::valueIsValid()
     * @uses \EnumType\StopMonitoringDetailEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stopMonitoringDetailLevel
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setStopMonitoringDetailLevel($stopMonitoringDetailLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StopMonitoringDetailEnumeration::valueIsValid($stopMonitoringDetailLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stopMonitoringDetailLevel, implode(', ', \EnumType\StopMonitoringDetailEnumeration::getValidValues())), __LINE__);
        }
        $this->StopMonitoringDetailLevel = $stopMonitoringDetailLevel;
        return $this;
    }
    /**
     * Get IncludeSituations value
     * @return bool|null
     */
    public function getIncludeSituations()
    {
        return $this->IncludeSituations;
    }
    /**
     * Set IncludeSituations value
     * @param bool $includeSituations
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setIncludeSituations($includeSituations = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSituations) && !is_bool($includeSituations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeSituations)), __LINE__);
        }
        $this->IncludeSituations = $includeSituations;
        return $this;
    }
    /**
     * Get MaximumNumberOfCalls value
     * @return \StructType\MaximumNumberOfCalls|null
     */
    public function getMaximumNumberOfCalls()
    {
        return $this->MaximumNumberOfCalls;
    }
    /**
     * Set MaximumNumberOfCalls value
     * @param \StructType\MaximumNumberOfCalls $maximumNumberOfCalls
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setMaximumNumberOfCalls(\StructType\MaximumNumberOfCalls $maximumNumberOfCalls = null)
    {
        $this->MaximumNumberOfCalls = $maximumNumberOfCalls;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\StopMonitoringRequestStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopMonitoringRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
