<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopLineNoticeStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for a Stop Line Notice.
 * @subpackage Structs
 */
class StopLineNoticeStructure extends AbstractIdentifiedItemStructure
{
    /**
     * The MonitoringRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a stop monitoring point to which LINE notice applies.
     * @var \StructType\MonitoringRefStructure
     */
    public $MonitoringRef;
    /**
     * The LineRef
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The DirectionRef
     * @var \StructType\DirectionRefStructure
     */
    public $DirectionRef;
    /**
     * The PublishedLineName
     * Meta informations extracted from the WSDL
     * - documentation: Name or Number by which the LINE is known to the public. +SIRI v2.0
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $PublishedLineName;
    /**
     * The LineNote
     * Meta informations extracted from the WSDL
     * - documentation: Special text associated with LINE.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $LineNote;
    /**
     * The DeliveryVariant
     * Meta informations extracted from the WSDL
     * - documentation: Variant of a notice for use in a particular media channel. +SIRI v2.0
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DeliveryVariantStructure[]
     */
    public $DeliveryVariant;
    /**
     * The SituationRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: SituationRef
     * @var \StructType\SituationRefStructure[]
     */
    public $SituationRef;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for StopLineNoticeStructure
     * @uses StopLineNoticeStructure::setMonitoringRef()
     * @uses StopLineNoticeStructure::setLineRef()
     * @uses StopLineNoticeStructure::setDirectionRef()
     * @uses StopLineNoticeStructure::setPublishedLineName()
     * @uses StopLineNoticeStructure::setLineNote()
     * @uses StopLineNoticeStructure::setDeliveryVariant()
     * @uses StopLineNoticeStructure::setSituationRef()
     * @uses StopLineNoticeStructure::setExtensions()
     * @param \StructType\MonitoringRefStructure $monitoringRef
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\DirectionRefStructure $directionRef
     * @param \StructType\NaturalLanguageStringStructure[] $publishedLineName
     * @param \StructType\NaturalLanguageStringStructure[] $lineNote
     * @param \StructType\DeliveryVariantStructure[] $deliveryVariant
     * @param \StructType\SituationRefStructure[] $situationRef
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\MonitoringRefStructure $monitoringRef = null, \StructType\LineRefStructure $lineRef = null, \StructType\DirectionRefStructure $directionRef = null, array $publishedLineName = array(), array $lineNote = array(), array $deliveryVariant = array(), array $situationRef = array(), \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setMonitoringRef($monitoringRef)
            ->setLineRef($lineRef)
            ->setDirectionRef($directionRef)
            ->setPublishedLineName($publishedLineName)
            ->setLineNote($lineNote)
            ->setDeliveryVariant($deliveryVariant)
            ->setSituationRef($situationRef)
            ->setExtensions($extensions);
    }
    /**
     * Get MonitoringRef value
     * @return \StructType\MonitoringRefStructure|null
     */
    public function getMonitoringRef()
    {
        return $this->MonitoringRef;
    }
    /**
     * Set MonitoringRef value
     * @param \StructType\MonitoringRefStructure $monitoringRef
     * @return \StructType\StopLineNoticeStructure
     */
    public function setMonitoringRef(\StructType\MonitoringRefStructure $monitoringRef = null)
    {
        $this->MonitoringRef = $monitoringRef;
        return $this;
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\StopLineNoticeStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get DirectionRef value
     * @return \StructType\DirectionRefStructure|null
     */
    public function getDirectionRef()
    {
        return $this->DirectionRef;
    }
    /**
     * Set DirectionRef value
     * @param \StructType\DirectionRefStructure $directionRef
     * @return \StructType\StopLineNoticeStructure
     */
    public function setDirectionRef(\StructType\DirectionRefStructure $directionRef = null)
    {
        $this->DirectionRef = $directionRef;
        return $this;
    }
    /**
     * Get PublishedLineName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getPublishedLineName()
    {
        return $this->PublishedLineName;
    }
    /**
     * Set PublishedLineName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $publishedLineName
     * @return \StructType\StopLineNoticeStructure
     */
    public function setPublishedLineName(array $publishedLineName = array())
    {
        foreach ($publishedLineName as $stopLineNoticeStructurePublishedLineNameItem) {
            // validation for constraint: itemType
            if (!$stopLineNoticeStructurePublishedLineNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The PublishedLineName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($stopLineNoticeStructurePublishedLineNameItem) ? get_class($stopLineNoticeStructurePublishedLineNameItem) : gettype($stopLineNoticeStructurePublishedLineNameItem)), __LINE__);
            }
        }
        $this->PublishedLineName = $publishedLineName;
        return $this;
    }
    /**
     * Add item to PublishedLineName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\StopLineNoticeStructure
     */
    public function addToPublishedLineName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The PublishedLineName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PublishedLineName[] = $item;
        return $this;
    }
    /**
     * Get LineNote value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getLineNote()
    {
        return $this->LineNote;
    }
    /**
     * Set LineNote value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $lineNote
     * @return \StructType\StopLineNoticeStructure
     */
    public function setLineNote(array $lineNote = array())
    {
        foreach ($lineNote as $stopLineNoticeStructureLineNoteItem) {
            // validation for constraint: itemType
            if (!$stopLineNoticeStructureLineNoteItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The LineNote property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($stopLineNoticeStructureLineNoteItem) ? get_class($stopLineNoticeStructureLineNoteItem) : gettype($stopLineNoticeStructureLineNoteItem)), __LINE__);
            }
        }
        $this->LineNote = $lineNote;
        return $this;
    }
    /**
     * Add item to LineNote value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\StopLineNoticeStructure
     */
    public function addToLineNote(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The LineNote property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LineNote[] = $item;
        return $this;
    }
    /**
     * Get DeliveryVariant value
     * @return \StructType\DeliveryVariantStructure[]|null
     */
    public function getDeliveryVariant()
    {
        return $this->DeliveryVariant;
    }
    /**
     * Set DeliveryVariant value
     * @throws \InvalidArgumentException
     * @param \StructType\DeliveryVariantStructure[] $deliveryVariant
     * @return \StructType\StopLineNoticeStructure
     */
    public function setDeliveryVariant(array $deliveryVariant = array())
    {
        foreach ($deliveryVariant as $stopLineNoticeStructureDeliveryVariantItem) {
            // validation for constraint: itemType
            if (!$stopLineNoticeStructureDeliveryVariantItem instanceof \StructType\DeliveryVariantStructure) {
                throw new \InvalidArgumentException(sprintf('The DeliveryVariant property can only contain items of \StructType\DeliveryVariantStructure, "%s" given', is_object($stopLineNoticeStructureDeliveryVariantItem) ? get_class($stopLineNoticeStructureDeliveryVariantItem) : gettype($stopLineNoticeStructureDeliveryVariantItem)), __LINE__);
            }
        }
        $this->DeliveryVariant = $deliveryVariant;
        return $this;
    }
    /**
     * Add item to DeliveryVariant value
     * @throws \InvalidArgumentException
     * @param \StructType\DeliveryVariantStructure $item
     * @return \StructType\StopLineNoticeStructure
     */
    public function addToDeliveryVariant(\StructType\DeliveryVariantStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeliveryVariantStructure) {
            throw new \InvalidArgumentException(sprintf('The DeliveryVariant property can only contain items of \StructType\DeliveryVariantStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeliveryVariant[] = $item;
        return $this;
    }
    /**
     * Get SituationRef value
     * @return \StructType\SituationRefStructure[]|null
     */
    public function getSituationRef()
    {
        return $this->SituationRef;
    }
    /**
     * Set SituationRef value
     * @throws \InvalidArgumentException
     * @param \StructType\SituationRefStructure[] $situationRef
     * @return \StructType\StopLineNoticeStructure
     */
    public function setSituationRef(array $situationRef = array())
    {
        foreach ($situationRef as $stopLineNoticeStructureSituationRefItem) {
            // validation for constraint: itemType
            if (!$stopLineNoticeStructureSituationRefItem instanceof \StructType\SituationRefStructure) {
                throw new \InvalidArgumentException(sprintf('The SituationRef property can only contain items of \StructType\SituationRefStructure, "%s" given', is_object($stopLineNoticeStructureSituationRefItem) ? get_class($stopLineNoticeStructureSituationRefItem) : gettype($stopLineNoticeStructureSituationRefItem)), __LINE__);
            }
        }
        $this->SituationRef = $situationRef;
        return $this;
    }
    /**
     * Add item to SituationRef value
     * @throws \InvalidArgumentException
     * @param \StructType\SituationRefStructure $item
     * @return \StructType\StopLineNoticeStructure
     */
    public function addToSituationRef(\StructType\SituationRefStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SituationRefStructure) {
            throw new \InvalidArgumentException(sprintf('The SituationRef property can only contain items of \StructType\SituationRefStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SituationRef[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\StopLineNoticeStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopLineNoticeStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
