<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopAssignmentStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for assignment of a SCHEDULED STOP POINT to a specific QUAY or platform +SIRI v2.0.
 * @subpackage Structs
 */
class StopAssignmentStructure extends AbstractStructBase
{
    /**
     * The AimedQuayRef
     * Meta informations extracted from the WSDL
     * - documentation: Physical QUAY to use according to the planned timetable. +SIRI v2.0
     * - minOccurs: 0
     * @var \StructType\QuayRefStructure
     */
    public $AimedQuayRef;
    /**
     * The AimedQuayName
     * Meta informations extracted from the WSDL
     * - documentation: Scheduled Platform name. Can be used to indicate platfrom change. +SIRI v2.0
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $AimedQuayName;
    /**
     * The ExpectedQuayRef
     * Meta informations extracted from the WSDL
     * - documentation: Physical QUAY to use accoring to the real-time prediction. +SIRI v2.0
     * - minOccurs: 0
     * @var \StructType\QuayRefStructure
     */
    public $ExpectedQuayRef;
    /**
     * The ActualQuayRef
     * Meta informations extracted from the WSDL
     * - documentation: Physical QUAY actually used. +SIRI v2.0
     * - minOccurs: 0
     * @var \StructType\QuayRefStructure
     */
    public $ActualQuayRef;
    /**
     * Constructor method for StopAssignmentStructure
     * @uses StopAssignmentStructure::setAimedQuayRef()
     * @uses StopAssignmentStructure::setAimedQuayName()
     * @uses StopAssignmentStructure::setExpectedQuayRef()
     * @uses StopAssignmentStructure::setActualQuayRef()
     * @param \StructType\QuayRefStructure $aimedQuayRef
     * @param \StructType\NaturalLanguageStringStructure[] $aimedQuayName
     * @param \StructType\QuayRefStructure $expectedQuayRef
     * @param \StructType\QuayRefStructure $actualQuayRef
     */
    public function __construct(\StructType\QuayRefStructure $aimedQuayRef = null, array $aimedQuayName = array(), \StructType\QuayRefStructure $expectedQuayRef = null, \StructType\QuayRefStructure $actualQuayRef = null)
    {
        $this
            ->setAimedQuayRef($aimedQuayRef)
            ->setAimedQuayName($aimedQuayName)
            ->setExpectedQuayRef($expectedQuayRef)
            ->setActualQuayRef($actualQuayRef);
    }
    /**
     * Get AimedQuayRef value
     * @return \StructType\QuayRefStructure|null
     */
    public function getAimedQuayRef()
    {
        return $this->AimedQuayRef;
    }
    /**
     * Set AimedQuayRef value
     * @param \StructType\QuayRefStructure $aimedQuayRef
     * @return \StructType\StopAssignmentStructure
     */
    public function setAimedQuayRef(\StructType\QuayRefStructure $aimedQuayRef = null)
    {
        $this->AimedQuayRef = $aimedQuayRef;
        return $this;
    }
    /**
     * Get AimedQuayName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getAimedQuayName()
    {
        return $this->AimedQuayName;
    }
    /**
     * Set AimedQuayName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $aimedQuayName
     * @return \StructType\StopAssignmentStructure
     */
    public function setAimedQuayName(array $aimedQuayName = array())
    {
        foreach ($aimedQuayName as $stopAssignmentStructureAimedQuayNameItem) {
            // validation for constraint: itemType
            if (!$stopAssignmentStructureAimedQuayNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The AimedQuayName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($stopAssignmentStructureAimedQuayNameItem) ? get_class($stopAssignmentStructureAimedQuayNameItem) : gettype($stopAssignmentStructureAimedQuayNameItem)), __LINE__);
            }
        }
        $this->AimedQuayName = $aimedQuayName;
        return $this;
    }
    /**
     * Add item to AimedQuayName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\StopAssignmentStructure
     */
    public function addToAimedQuayName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The AimedQuayName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AimedQuayName[] = $item;
        return $this;
    }
    /**
     * Get ExpectedQuayRef value
     * @return \StructType\QuayRefStructure|null
     */
    public function getExpectedQuayRef()
    {
        return $this->ExpectedQuayRef;
    }
    /**
     * Set ExpectedQuayRef value
     * @param \StructType\QuayRefStructure $expectedQuayRef
     * @return \StructType\StopAssignmentStructure
     */
    public function setExpectedQuayRef(\StructType\QuayRefStructure $expectedQuayRef = null)
    {
        $this->ExpectedQuayRef = $expectedQuayRef;
        return $this;
    }
    /**
     * Get ActualQuayRef value
     * @return \StructType\QuayRefStructure|null
     */
    public function getActualQuayRef()
    {
        return $this->ActualQuayRef;
    }
    /**
     * Set ActualQuayRef value
     * @param \StructType\QuayRefStructure $actualQuayRef
     * @return \StructType\StopAssignmentStructure
     */
    public function setActualQuayRef(\StructType\QuayRefStructure $actualQuayRef = null)
    {
        $this->ActualQuayRef = $actualQuayRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopAssignmentStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
