<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SituationRoadFilter StructType
 * Meta informations extracted from the WSDL
 * - documentation: Parameters to filter Situation Exchange Service requests, based on the SITUATION Road. Logically ANDed with other values.
 * - minOccurs: 0
 * @subpackage Structs
 */
class SituationRoadFilter extends AbstractStructBase
{
    /**
     * The RoadFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\RoadFilterStructure[]
     */
    public $RoadFilter;
    /**
     * Constructor method for SituationRoadFilter
     * @uses SituationRoadFilter::setRoadFilter()
     * @param \StructType\RoadFilterStructure[] $roadFilter
     */
    public function __construct(array $roadFilter = array())
    {
        $this
            ->setRoadFilter($roadFilter);
    }
    /**
     * Get RoadFilter value
     * @return \StructType\RoadFilterStructure[]|null
     */
    public function getRoadFilter()
    {
        return $this->RoadFilter;
    }
    /**
     * Set RoadFilter value
     * @throws \InvalidArgumentException
     * @param \StructType\RoadFilterStructure[] $roadFilter
     * @return \StructType\SituationRoadFilter
     */
    public function setRoadFilter(array $roadFilter = array())
    {
        foreach ($roadFilter as $situationRoadFilterRoadFilterItem) {
            // validation for constraint: itemType
            if (!$situationRoadFilterRoadFilterItem instanceof \StructType\RoadFilterStructure) {
                throw new \InvalidArgumentException(sprintf('The RoadFilter property can only contain items of \StructType\RoadFilterStructure, "%s" given', is_object($situationRoadFilterRoadFilterItem) ? get_class($situationRoadFilterRoadFilterItem) : gettype($situationRoadFilterRoadFilterItem)), __LINE__);
            }
        }
        $this->RoadFilter = $roadFilter;
        return $this;
    }
    /**
     * Add item to RoadFilter value
     * @throws \InvalidArgumentException
     * @param \StructType\RoadFilterStructure $item
     * @return \StructType\SituationRoadFilter
     */
    public function addToRoadFilter(\StructType\RoadFilterStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoadFilterStructure) {
            throw new \InvalidArgumentException(sprintf('The RoadFilter property can only contain items of \StructType\RoadFilterStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoadFilter[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SituationRoadFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
