<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SiteMeasurements StructType
 * @subpackage Structs
 */
class SiteMeasurements extends AbstractStructBase
{
    /**
     * The measurementSiteReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $measurementSiteReference;
    /**
     * The measurementTimeDefault
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $measurementTimeDefault;
    /**
     * The measuredValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\MeasuredValue_1[]
     */
    public $measuredValue;
    /**
     * The siteMeasurementsExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $siteMeasurementsExtension;
    /**
     * Constructor method for SiteMeasurements
     * @uses SiteMeasurements::setMeasurementSiteReference()
     * @uses SiteMeasurements::setMeasurementTimeDefault()
     * @uses SiteMeasurements::setMeasuredValue()
     * @uses SiteMeasurements::setSiteMeasurementsExtension()
     * @param string $measurementSiteReference
     * @param string $measurementTimeDefault
     * @param \StructType\MeasuredValue_1[] $measuredValue
     * @param \StructType\ExtensionType $siteMeasurementsExtension
     */
    public function __construct($measurementSiteReference = null, $measurementTimeDefault = null, array $measuredValue = array(), \StructType\ExtensionType $siteMeasurementsExtension = null)
    {
        $this
            ->setMeasurementSiteReference($measurementSiteReference)
            ->setMeasurementTimeDefault($measurementTimeDefault)
            ->setMeasuredValue($measuredValue)
            ->setSiteMeasurementsExtension($siteMeasurementsExtension);
    }
    /**
     * Get measurementSiteReference value
     * @return string
     */
    public function getMeasurementSiteReference()
    {
        return $this->measurementSiteReference;
    }
    /**
     * Set measurementSiteReference value
     * @param string $measurementSiteReference
     * @return \StructType\SiteMeasurements
     */
    public function setMeasurementSiteReference($measurementSiteReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($measurementSiteReference) && strlen($measurementSiteReference) > 1024) || (is_array($measurementSiteReference) && count($measurementSiteReference) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($measurementSiteReference) ? strlen($measurementSiteReference) : count($measurementSiteReference)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($measurementSiteReference) && !is_string($measurementSiteReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($measurementSiteReference)), __LINE__);
        }
        $this->measurementSiteReference = $measurementSiteReference;
        return $this;
    }
    /**
     * Get measurementTimeDefault value
     * @return string
     */
    public function getMeasurementTimeDefault()
    {
        return $this->measurementTimeDefault;
    }
    /**
     * Set measurementTimeDefault value
     * @param string $measurementTimeDefault
     * @return \StructType\SiteMeasurements
     */
    public function setMeasurementTimeDefault($measurementTimeDefault = null)
    {
        // validation for constraint: string
        if (!is_null($measurementTimeDefault) && !is_string($measurementTimeDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($measurementTimeDefault)), __LINE__);
        }
        $this->measurementTimeDefault = $measurementTimeDefault;
        return $this;
    }
    /**
     * Get measuredValue value
     * @return \StructType\MeasuredValue_1[]
     */
    public function getMeasuredValue()
    {
        return $this->measuredValue;
    }
    /**
     * Set measuredValue value
     * @throws \InvalidArgumentException
     * @param \StructType\MeasuredValue_1[] $measuredValue
     * @return \StructType\SiteMeasurements
     */
    public function setMeasuredValue(array $measuredValue = array())
    {
        foreach ($measuredValue as $siteMeasurementsMeasuredValueItem) {
            // validation for constraint: itemType
            if (!$siteMeasurementsMeasuredValueItem instanceof \StructType\MeasuredValue_1) {
                throw new \InvalidArgumentException(sprintf('The measuredValue property can only contain items of \StructType\MeasuredValue_1, "%s" given', is_object($siteMeasurementsMeasuredValueItem) ? get_class($siteMeasurementsMeasuredValueItem) : gettype($siteMeasurementsMeasuredValueItem)), __LINE__);
            }
        }
        $this->measuredValue = $measuredValue;
        return $this;
    }
    /**
     * Add item to measuredValue value
     * @throws \InvalidArgumentException
     * @param \StructType\MeasuredValue_1 $item
     * @return \StructType\SiteMeasurements
     */
    public function addToMeasuredValue(\StructType\MeasuredValue_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MeasuredValue_1) {
            throw new \InvalidArgumentException(sprintf('The measuredValue property can only contain items of \StructType\MeasuredValue_1, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->measuredValue[] = $item;
        return $this;
    }
    /**
     * Get siteMeasurementsExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getSiteMeasurementsExtension()
    {
        return $this->siteMeasurementsExtension;
    }
    /**
     * Set siteMeasurementsExtension value
     * @param \StructType\ExtensionType $siteMeasurementsExtension
     * @return \StructType\SiteMeasurements
     */
    public function setSiteMeasurementsExtension(\StructType\ExtensionType $siteMeasurementsExtension = null)
    {
        $this->siteMeasurementsExtension = $siteMeasurementsExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SiteMeasurements
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
