<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceFeatureStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Service Feature description.
 * @subpackage Structs
 */
class ServiceFeatureStructure extends AbstractStructBase
{
    /**
     * The ServiceFeatureCode
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of classification. SIRI provides a recommended set of values covering most usages, intended to be TPEG compatible. See the SIRI facilities packaged. | Type for identifier of a ServiceCategory. SIRI provides a recommended
     * set of values covering most usages, intended to be TPEG comnpatible. See the SIRI facilities packaged.
     * @var string
     */
    public $ServiceFeatureCode;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Name of classification. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $Name;
    /**
     * The Icon
     * Meta informations extracted from the WSDL
     * - documentation: Icon associated with feature.
     * @var string
     */
    public $Icon;
    /**
     * Constructor method for ServiceFeatureStructure
     * @uses ServiceFeatureStructure::setServiceFeatureCode()
     * @uses ServiceFeatureStructure::setName()
     * @uses ServiceFeatureStructure::setIcon()
     * @param string $serviceFeatureCode
     * @param \StructType\NaturalLanguageStringStructure[] $name
     * @param string $icon
     */
    public function __construct($serviceFeatureCode = null, array $name = array(), $icon = null)
    {
        $this
            ->setServiceFeatureCode($serviceFeatureCode)
            ->setName($name)
            ->setIcon($icon);
    }
    /**
     * Get ServiceFeatureCode value
     * @return string|null
     */
    public function getServiceFeatureCode()
    {
        return $this->ServiceFeatureCode;
    }
    /**
     * Set ServiceFeatureCode value
     * @param string $serviceFeatureCode
     * @return \StructType\ServiceFeatureStructure
     */
    public function setServiceFeatureCode($serviceFeatureCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceFeatureCode) && !is_string($serviceFeatureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceFeatureCode)), __LINE__);
        }
        $this->ServiceFeatureCode = $serviceFeatureCode;
        return $this;
    }
    /**
     * Get Name value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $name
     * @return \StructType\ServiceFeatureStructure
     */
    public function setName(array $name = array())
    {
        foreach ($name as $serviceFeatureStructureNameItem) {
            // validation for constraint: itemType
            if (!$serviceFeatureStructureNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The Name property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($serviceFeatureStructureNameItem) ? get_class($serviceFeatureStructureNameItem) : gettype($serviceFeatureStructureNameItem)), __LINE__);
            }
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Add item to Name value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\ServiceFeatureStructure
     */
    public function addToName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The Name property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Name[] = $item;
        return $this;
    }
    /**
     * Get Icon value
     * @return string|null
     */
    public function getIcon()
    {
        return $this->Icon;
    }
    /**
     * Set Icon value
     * @param string $icon
     * @return \StructType\ServiceFeatureStructure
     */
    public function setIcon($icon = null)
    {
        // validation for constraint: string
        if (!is_null($icon) && !is_string($icon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($icon)), __LINE__);
        }
        $this->Icon = $icon;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceFeatureStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
