<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceExceptionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for whether service is unavailable for all or some services SIRI 2.0
 * @subpackage Structs
 */
class ServiceExceptionStructure extends AbstractItemStructure
{
    /**
     * The LineRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: LineRef
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The DirectionRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a LINE DIRECTION to which exception applies.
     * - minOccurs: 0
     * @var \StructType\DirectionRefStructure
     */
    public $DirectionRef;
    /**
     * The StopPointRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: StopPointRef
     * @var \StructType\StopPointRefStructure
     */
    public $StopPointRef;
    /**
     * The ServiceStatus
     * Meta informations extracted from the WSDL
     * - documentation: Status of service, Service not yet started, Service ended for day, no service today, etc.
     * - minOccurs: 0
     * @var string
     */
    public $ServiceStatus;
    /**
     * The Notice
     * Meta informations extracted from the WSDL
     * - documentation: Text explanation of service exception.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $Notice;
    /**
     * The SituationRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a SITUATION providing further information about exception
     * - minOccurs: 0
     * @var \StructType\SituationSimpleRefStructure
     */
    public $SituationRef;
    /**
     * Constructor method for ServiceExceptionStructure
     * @uses ServiceExceptionStructure::setLineRef()
     * @uses ServiceExceptionStructure::setDirectionRef()
     * @uses ServiceExceptionStructure::setStopPointRef()
     * @uses ServiceExceptionStructure::setServiceStatus()
     * @uses ServiceExceptionStructure::setNotice()
     * @uses ServiceExceptionStructure::setSituationRef()
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\DirectionRefStructure $directionRef
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @param string $serviceStatus
     * @param \StructType\NaturalLanguageStringStructure[] $notice
     * @param \StructType\SituationSimpleRefStructure $situationRef
     */
    public function __construct(\StructType\LineRefStructure $lineRef = null, \StructType\DirectionRefStructure $directionRef = null, \StructType\StopPointRefStructure $stopPointRef = null, $serviceStatus = null, array $notice = array(), \StructType\SituationSimpleRefStructure $situationRef = null)
    {
        $this
            ->setLineRef($lineRef)
            ->setDirectionRef($directionRef)
            ->setStopPointRef($stopPointRef)
            ->setServiceStatus($serviceStatus)
            ->setNotice($notice)
            ->setSituationRef($situationRef);
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\ServiceExceptionStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get DirectionRef value
     * @return \StructType\DirectionRefStructure|null
     */
    public function getDirectionRef()
    {
        return $this->DirectionRef;
    }
    /**
     * Set DirectionRef value
     * @param \StructType\DirectionRefStructure $directionRef
     * @return \StructType\ServiceExceptionStructure
     */
    public function setDirectionRef(\StructType\DirectionRefStructure $directionRef = null)
    {
        $this->DirectionRef = $directionRef;
        return $this;
    }
    /**
     * Get StopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getStopPointRef()
    {
        return $this->StopPointRef;
    }
    /**
     * Set StopPointRef value
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @return \StructType\ServiceExceptionStructure
     */
    public function setStopPointRef(\StructType\StopPointRefStructure $stopPointRef = null)
    {
        $this->StopPointRef = $stopPointRef;
        return $this;
    }
    /**
     * Get ServiceStatus value
     * @return string|null
     */
    public function getServiceStatus()
    {
        return $this->ServiceStatus;
    }
    /**
     * Set ServiceStatus value
     * @uses \EnumType\ServiceExceptionEnumeration::valueIsValid()
     * @uses \EnumType\ServiceExceptionEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceStatus
     * @return \StructType\ServiceExceptionStructure
     */
    public function setServiceStatus($serviceStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceExceptionEnumeration::valueIsValid($serviceStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceStatus, implode(', ', \EnumType\ServiceExceptionEnumeration::getValidValues())), __LINE__);
        }
        $this->ServiceStatus = $serviceStatus;
        return $this;
    }
    /**
     * Get Notice value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getNotice()
    {
        return $this->Notice;
    }
    /**
     * Set Notice value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $notice
     * @return \StructType\ServiceExceptionStructure
     */
    public function setNotice(array $notice = array())
    {
        foreach ($notice as $serviceExceptionStructureNoticeItem) {
            // validation for constraint: itemType
            if (!$serviceExceptionStructureNoticeItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The Notice property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($serviceExceptionStructureNoticeItem) ? get_class($serviceExceptionStructureNoticeItem) : gettype($serviceExceptionStructureNoticeItem)), __LINE__);
            }
        }
        $this->Notice = $notice;
        return $this;
    }
    /**
     * Add item to Notice value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\ServiceExceptionStructure
     */
    public function addToNotice(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The Notice property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Notice[] = $item;
        return $this;
    }
    /**
     * Get SituationRef value
     * @return \StructType\SituationSimpleRefStructure|null
     */
    public function getSituationRef()
    {
        return $this->SituationRef;
    }
    /**
     * Set SituationRef value
     * @param \StructType\SituationSimpleRefStructure $situationRef
     * @return \StructType\ServiceExceptionStructure
     */
    public function setSituationRef(\StructType\SituationSimpleRefStructure $situationRef = null)
    {
        $this->SituationRef = $situationRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceExceptionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
