<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Routes StructType
 * Meta informations extracted from the WSDL
 * - documentation: ROUTEs affected if LINE has multiple ROUTEs.
 * @subpackage Structs
 */
class Routes extends AbstractStructBase
{
    /**
     * The AffectedRoute
     * Meta informations extracted from the WSDL
     * - documentation: Route affected by Situation.
     * - maxOccurs: unbounded
     * @var \StructType\AffectedRouteStructure[]
     */
    public $AffectedRoute;
    /**
     * Constructor method for Routes
     * @uses Routes::setAffectedRoute()
     * @param \StructType\AffectedRouteStructure[] $affectedRoute
     */
    public function __construct(array $affectedRoute = array())
    {
        $this
            ->setAffectedRoute($affectedRoute);
    }
    /**
     * Get AffectedRoute value
     * @return \StructType\AffectedRouteStructure[]|null
     */
    public function getAffectedRoute()
    {
        return $this->AffectedRoute;
    }
    /**
     * Set AffectedRoute value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedRouteStructure[] $affectedRoute
     * @return \StructType\Routes
     */
    public function setAffectedRoute(array $affectedRoute = array())
    {
        foreach ($affectedRoute as $routesAffectedRouteItem) {
            // validation for constraint: itemType
            if (!$routesAffectedRouteItem instanceof \StructType\AffectedRouteStructure) {
                throw new \InvalidArgumentException(sprintf('The AffectedRoute property can only contain items of \StructType\AffectedRouteStructure, "%s" given', is_object($routesAffectedRouteItem) ? get_class($routesAffectedRouteItem) : gettype($routesAffectedRouteItem)), __LINE__);
            }
        }
        $this->AffectedRoute = $affectedRoute;
        return $this;
    }
    /**
     * Add item to AffectedRoute value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedRouteStructure $item
     * @return \StructType\Routes
     */
    public function addToAffectedRoute(\StructType\AffectedRouteStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedRouteStructure) {
            throw new \InvalidArgumentException(sprintf('The AffectedRoute property can only contain items of \StructType\AffectedRouteStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AffectedRoute[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Routes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
