<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RouteLinks StructType
 * Meta informations extracted from the WSDL
 * - documentation: ROUTE LINKs affected by SITUATION.
 * @subpackage Structs
 */
class RouteLinks extends AbstractStructBase
{
    /**
     * The RouteLinkRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\RouteLinkRefStructure[]
     */
    public $RouteLinkRef;
    /**
     * Constructor method for RouteLinks
     * @uses RouteLinks::setRouteLinkRef()
     * @param \StructType\RouteLinkRefStructure[] $routeLinkRef
     */
    public function __construct(array $routeLinkRef = array())
    {
        $this
            ->setRouteLinkRef($routeLinkRef);
    }
    /**
     * Get RouteLinkRef value
     * @return \StructType\RouteLinkRefStructure[]|null
     */
    public function getRouteLinkRef()
    {
        return $this->RouteLinkRef;
    }
    /**
     * Set RouteLinkRef value
     * @throws \InvalidArgumentException
     * @param \StructType\RouteLinkRefStructure[] $routeLinkRef
     * @return \StructType\RouteLinks
     */
    public function setRouteLinkRef(array $routeLinkRef = array())
    {
        foreach ($routeLinkRef as $routeLinksRouteLinkRefItem) {
            // validation for constraint: itemType
            if (!$routeLinksRouteLinkRefItem instanceof \StructType\RouteLinkRefStructure) {
                throw new \InvalidArgumentException(sprintf('The RouteLinkRef property can only contain items of \StructType\RouteLinkRefStructure, "%s" given', is_object($routeLinksRouteLinkRefItem) ? get_class($routeLinksRouteLinkRefItem) : gettype($routeLinksRouteLinkRefItem)), __LINE__);
            }
        }
        $this->RouteLinkRef = $routeLinkRef;
        return $this;
    }
    /**
     * Add item to RouteLinkRef value
     * @throws \InvalidArgumentException
     * @param \StructType\RouteLinkRefStructure $item
     * @return \StructType\RouteLinks
     */
    public function addToRouteLinkRef(\StructType\RouteLinkRefStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RouteLinkRefStructure) {
            throw new \InvalidArgumentException(sprintf('The RouteLinkRef property can only contain items of \StructType\RouteLinkRefStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RouteLinkRef[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RouteLinks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
