<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoadsideServiceDisruption StructType
 * @subpackage Structs
 */
class RoadsideServiceDisruption extends NonRoadEventInformation
{
    /**
     * The roadsideServiceDisruptionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $roadsideServiceDisruptionType;
    /**
     * The roadsideServiceDisruptionExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $roadsideServiceDisruptionExtension;
    /**
     * Constructor method for RoadsideServiceDisruption
     * @uses RoadsideServiceDisruption::setRoadsideServiceDisruptionType()
     * @uses RoadsideServiceDisruption::setRoadsideServiceDisruptionExtension()
     * @param string[] $roadsideServiceDisruptionType
     * @param \StructType\ExtensionType $roadsideServiceDisruptionExtension
     */
    public function __construct(array $roadsideServiceDisruptionType = array(), \StructType\ExtensionType $roadsideServiceDisruptionExtension = null)
    {
        $this
            ->setRoadsideServiceDisruptionType($roadsideServiceDisruptionType)
            ->setRoadsideServiceDisruptionExtension($roadsideServiceDisruptionExtension);
    }
    /**
     * Get roadsideServiceDisruptionType value
     * @return string[]
     */
    public function getRoadsideServiceDisruptionType()
    {
        return $this->roadsideServiceDisruptionType;
    }
    /**
     * Set roadsideServiceDisruptionType value
     * @uses \EnumType\RoadsideServiceDisruptionTypeEnum::valueIsValid()
     * @uses \EnumType\RoadsideServiceDisruptionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $roadsideServiceDisruptionType
     * @return \StructType\RoadsideServiceDisruption
     */
    public function setRoadsideServiceDisruptionType(array $roadsideServiceDisruptionType = array())
    {
        $invalidValues = array();
        foreach ($roadsideServiceDisruptionType as $roadsideServiceDisruptionRoadsideServiceDisruptionTypeItem) {
            if (!\EnumType\RoadsideServiceDisruptionTypeEnum::valueIsValid($roadsideServiceDisruptionRoadsideServiceDisruptionTypeItem)) {
                $invalidValues[] = var_export($roadsideServiceDisruptionRoadsideServiceDisruptionTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\RoadsideServiceDisruptionTypeEnum::getValidValues())), __LINE__);
        }
        $this->roadsideServiceDisruptionType = $roadsideServiceDisruptionType;
        return $this;
    }
    /**
     * Add item to roadsideServiceDisruptionType value
     * @uses \EnumType\RoadsideServiceDisruptionTypeEnum::valueIsValid()
     * @uses \EnumType\RoadsideServiceDisruptionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RoadsideServiceDisruption
     */
    public function addToRoadsideServiceDisruptionType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoadsideServiceDisruptionTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\RoadsideServiceDisruptionTypeEnum::getValidValues())), __LINE__);
        }
        $this->roadsideServiceDisruptionType[] = $item;
        return $this;
    }
    /**
     * Get roadsideServiceDisruptionExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getRoadsideServiceDisruptionExtension()
    {
        return $this->roadsideServiceDisruptionExtension;
    }
    /**
     * Set roadsideServiceDisruptionExtension value
     * @param \StructType\ExtensionType $roadsideServiceDisruptionExtension
     * @return \StructType\RoadsideServiceDisruption
     */
    public function setRoadsideServiceDisruptionExtension(\StructType\ExtensionType $roadsideServiceDisruptionExtension = null)
    {
        $this->roadsideServiceDisruptionExtension = $roadsideServiceDisruptionExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoadsideServiceDisruption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
