<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoadsideReferencePoint StructType
 * @subpackage Structs
 */
class RoadsideReferencePoint extends AbstractStructBase
{
    /**
     * The roadsideReferencePointIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $roadsideReferencePointIdentifier;
    /**
     * The administrativeArea
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $administrativeArea;
    /**
     * The roadName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $roadName;
    /**
     * The roadNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $roadNumber;
    /**
     * The directionBound
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $directionBound;
    /**
     * The directionRelative
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $directionRelative;
    /**
     * The distanceFromPrevious
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $distanceFromPrevious;
    /**
     * The distanceToNext
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $distanceToNext;
    /**
     * The elevatedRoadSection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $elevatedRoadSection;
    /**
     * The roadsideReferencePointDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $roadsideReferencePointDescription;
    /**
     * The roadsideReferencePointDistance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $roadsideReferencePointDistance;
    /**
     * The roadsideReferencePointExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $roadsideReferencePointExtension;
    /**
     * Constructor method for RoadsideReferencePoint
     * @uses RoadsideReferencePoint::setRoadsideReferencePointIdentifier()
     * @uses RoadsideReferencePoint::setAdministrativeArea()
     * @uses RoadsideReferencePoint::setRoadName()
     * @uses RoadsideReferencePoint::setRoadNumber()
     * @uses RoadsideReferencePoint::setDirectionBound()
     * @uses RoadsideReferencePoint::setDirectionRelative()
     * @uses RoadsideReferencePoint::setDistanceFromPrevious()
     * @uses RoadsideReferencePoint::setDistanceToNext()
     * @uses RoadsideReferencePoint::setElevatedRoadSection()
     * @uses RoadsideReferencePoint::setRoadsideReferencePointDescription()
     * @uses RoadsideReferencePoint::setRoadsideReferencePointDistance()
     * @uses RoadsideReferencePoint::setRoadsideReferencePointExtension()
     * @param string $roadsideReferencePointIdentifier
     * @param \StructType\MultilingualString $administrativeArea
     * @param \StructType\MultilingualString $roadName
     * @param string $roadNumber
     * @param string $directionBound
     * @param string $directionRelative
     * @param float $distanceFromPrevious
     * @param float $distanceToNext
     * @param bool $elevatedRoadSection
     * @param \StructType\MultilingualString $roadsideReferencePointDescription
     * @param float $roadsideReferencePointDistance
     * @param \StructType\ExtensionType $roadsideReferencePointExtension
     */
    public function __construct($roadsideReferencePointIdentifier = null, \StructType\MultilingualString $administrativeArea = null, \StructType\MultilingualString $roadName = null, $roadNumber = null, $directionBound = null, $directionRelative = null, $distanceFromPrevious = null, $distanceToNext = null, $elevatedRoadSection = null, \StructType\MultilingualString $roadsideReferencePointDescription = null, $roadsideReferencePointDistance = null, \StructType\ExtensionType $roadsideReferencePointExtension = null)
    {
        $this
            ->setRoadsideReferencePointIdentifier($roadsideReferencePointIdentifier)
            ->setAdministrativeArea($administrativeArea)
            ->setRoadName($roadName)
            ->setRoadNumber($roadNumber)
            ->setDirectionBound($directionBound)
            ->setDirectionRelative($directionRelative)
            ->setDistanceFromPrevious($distanceFromPrevious)
            ->setDistanceToNext($distanceToNext)
            ->setElevatedRoadSection($elevatedRoadSection)
            ->setRoadsideReferencePointDescription($roadsideReferencePointDescription)
            ->setRoadsideReferencePointDistance($roadsideReferencePointDistance)
            ->setRoadsideReferencePointExtension($roadsideReferencePointExtension);
    }
    /**
     * Get roadsideReferencePointIdentifier value
     * @return string
     */
    public function getRoadsideReferencePointIdentifier()
    {
        return $this->roadsideReferencePointIdentifier;
    }
    /**
     * Set roadsideReferencePointIdentifier value
     * @param string $roadsideReferencePointIdentifier
     * @return \StructType\RoadsideReferencePoint
     */
    public function setRoadsideReferencePointIdentifier($roadsideReferencePointIdentifier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($roadsideReferencePointIdentifier) && strlen($roadsideReferencePointIdentifier) > 1024) || (is_array($roadsideReferencePointIdentifier) && count($roadsideReferencePointIdentifier) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($roadsideReferencePointIdentifier) ? strlen($roadsideReferencePointIdentifier) : count($roadsideReferencePointIdentifier)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($roadsideReferencePointIdentifier) && !is_string($roadsideReferencePointIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roadsideReferencePointIdentifier)), __LINE__);
        }
        $this->roadsideReferencePointIdentifier = $roadsideReferencePointIdentifier;
        return $this;
    }
    /**
     * Get administrativeArea value
     * @return \StructType\MultilingualString|null
     */
    public function getAdministrativeArea()
    {
        return $this->administrativeArea;
    }
    /**
     * Set administrativeArea value
     * @param \StructType\MultilingualString $administrativeArea
     * @return \StructType\RoadsideReferencePoint
     */
    public function setAdministrativeArea(\StructType\MultilingualString $administrativeArea = null)
    {
        $this->administrativeArea = $administrativeArea;
        return $this;
    }
    /**
     * Get roadName value
     * @return \StructType\MultilingualString|null
     */
    public function getRoadName()
    {
        return $this->roadName;
    }
    /**
     * Set roadName value
     * @param \StructType\MultilingualString $roadName
     * @return \StructType\RoadsideReferencePoint
     */
    public function setRoadName(\StructType\MultilingualString $roadName = null)
    {
        $this->roadName = $roadName;
        return $this;
    }
    /**
     * Get roadNumber value
     * @return string|null
     */
    public function getRoadNumber()
    {
        return $this->roadNumber;
    }
    /**
     * Set roadNumber value
     * @param string $roadNumber
     * @return \StructType\RoadsideReferencePoint
     */
    public function setRoadNumber($roadNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($roadNumber) && strlen($roadNumber) > 1024) || (is_array($roadNumber) && count($roadNumber) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($roadNumber) ? strlen($roadNumber) : count($roadNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($roadNumber) && !is_string($roadNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roadNumber)), __LINE__);
        }
        $this->roadNumber = $roadNumber;
        return $this;
    }
    /**
     * Get directionBound value
     * @return string|null
     */
    public function getDirectionBound()
    {
        return $this->directionBound;
    }
    /**
     * Set directionBound value
     * @uses \EnumType\DirectionEnum::valueIsValid()
     * @uses \EnumType\DirectionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $directionBound
     * @return \StructType\RoadsideReferencePoint
     */
    public function setDirectionBound($directionBound = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DirectionEnum::valueIsValid($directionBound)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $directionBound, implode(', ', \EnumType\DirectionEnum::getValidValues())), __LINE__);
        }
        $this->directionBound = $directionBound;
        return $this;
    }
    /**
     * Get directionRelative value
     * @return string|null
     */
    public function getDirectionRelative()
    {
        return $this->directionRelative;
    }
    /**
     * Set directionRelative value
     * @uses \EnumType\ReferencePointDirectionEnum::valueIsValid()
     * @uses \EnumType\ReferencePointDirectionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $directionRelative
     * @return \StructType\RoadsideReferencePoint
     */
    public function setDirectionRelative($directionRelative = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReferencePointDirectionEnum::valueIsValid($directionRelative)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $directionRelative, implode(', ', \EnumType\ReferencePointDirectionEnum::getValidValues())), __LINE__);
        }
        $this->directionRelative = $directionRelative;
        return $this;
    }
    /**
     * Get distanceFromPrevious value
     * @return float|null
     */
    public function getDistanceFromPrevious()
    {
        return $this->distanceFromPrevious;
    }
    /**
     * Set distanceFromPrevious value
     * @param float $distanceFromPrevious
     * @return \StructType\RoadsideReferencePoint
     */
    public function setDistanceFromPrevious($distanceFromPrevious = null)
    {
        $this->distanceFromPrevious = $distanceFromPrevious;
        return $this;
    }
    /**
     * Get distanceToNext value
     * @return float|null
     */
    public function getDistanceToNext()
    {
        return $this->distanceToNext;
    }
    /**
     * Set distanceToNext value
     * @param float $distanceToNext
     * @return \StructType\RoadsideReferencePoint
     */
    public function setDistanceToNext($distanceToNext = null)
    {
        $this->distanceToNext = $distanceToNext;
        return $this;
    }
    /**
     * Get elevatedRoadSection value
     * @return bool|null
     */
    public function getElevatedRoadSection()
    {
        return $this->elevatedRoadSection;
    }
    /**
     * Set elevatedRoadSection value
     * @param bool $elevatedRoadSection
     * @return \StructType\RoadsideReferencePoint
     */
    public function setElevatedRoadSection($elevatedRoadSection = null)
    {
        // validation for constraint: boolean
        if (!is_null($elevatedRoadSection) && !is_bool($elevatedRoadSection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($elevatedRoadSection)), __LINE__);
        }
        $this->elevatedRoadSection = $elevatedRoadSection;
        return $this;
    }
    /**
     * Get roadsideReferencePointDescription value
     * @return \StructType\MultilingualString|null
     */
    public function getRoadsideReferencePointDescription()
    {
        return $this->roadsideReferencePointDescription;
    }
    /**
     * Set roadsideReferencePointDescription value
     * @param \StructType\MultilingualString $roadsideReferencePointDescription
     * @return \StructType\RoadsideReferencePoint
     */
    public function setRoadsideReferencePointDescription(\StructType\MultilingualString $roadsideReferencePointDescription = null)
    {
        $this->roadsideReferencePointDescription = $roadsideReferencePointDescription;
        return $this;
    }
    /**
     * Get roadsideReferencePointDistance value
     * @return float|null
     */
    public function getRoadsideReferencePointDistance()
    {
        return $this->roadsideReferencePointDistance;
    }
    /**
     * Set roadsideReferencePointDistance value
     * @param float $roadsideReferencePointDistance
     * @return \StructType\RoadsideReferencePoint
     */
    public function setRoadsideReferencePointDistance($roadsideReferencePointDistance = null)
    {
        $this->roadsideReferencePointDistance = $roadsideReferencePointDistance;
        return $this;
    }
    /**
     * Get roadsideReferencePointExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getRoadsideReferencePointExtension()
    {
        return $this->roadsideReferencePointExtension;
    }
    /**
     * Set roadsideReferencePointExtension value
     * @param \StructType\ExtensionType $roadsideReferencePointExtension
     * @return \StructType\RoadsideReferencePoint
     */
    public function setRoadsideReferencePointExtension(\StructType\ExtensionType $roadsideReferencePointExtension = null)
    {
        $this->roadsideReferencePointExtension = $roadsideReferencePointExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoadsideReferencePoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
