<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoadsideAssistance StructType
 * @subpackage Structs
 */
class RoadsideAssistance extends OperatorAction
{
    /**
     * The roadsideAssistanceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $roadsideAssistanceType;
    /**
     * The roadsideAssistanceExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $roadsideAssistanceExtension;
    /**
     * Constructor method for RoadsideAssistance
     * @uses RoadsideAssistance::setRoadsideAssistanceType()
     * @uses RoadsideAssistance::setRoadsideAssistanceExtension()
     * @param string $roadsideAssistanceType
     * @param \StructType\ExtensionType $roadsideAssistanceExtension
     */
    public function __construct($roadsideAssistanceType = null, \StructType\ExtensionType $roadsideAssistanceExtension = null)
    {
        $this
            ->setRoadsideAssistanceType($roadsideAssistanceType)
            ->setRoadsideAssistanceExtension($roadsideAssistanceExtension);
    }
    /**
     * Get roadsideAssistanceType value
     * @return string
     */
    public function getRoadsideAssistanceType()
    {
        return $this->roadsideAssistanceType;
    }
    /**
     * Set roadsideAssistanceType value
     * @uses \EnumType\RoadsideAssistanceTypeEnum::valueIsValid()
     * @uses \EnumType\RoadsideAssistanceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roadsideAssistanceType
     * @return \StructType\RoadsideAssistance
     */
    public function setRoadsideAssistanceType($roadsideAssistanceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoadsideAssistanceTypeEnum::valueIsValid($roadsideAssistanceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $roadsideAssistanceType, implode(', ', \EnumType\RoadsideAssistanceTypeEnum::getValidValues())), __LINE__);
        }
        $this->roadsideAssistanceType = $roadsideAssistanceType;
        return $this;
    }
    /**
     * Get roadsideAssistanceExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getRoadsideAssistanceExtension()
    {
        return $this->roadsideAssistanceExtension;
    }
    /**
     * Set roadsideAssistanceExtension value
     * @param \StructType\ExtensionType $roadsideAssistanceExtension
     * @return \StructType\RoadsideAssistance
     */
    public function setRoadsideAssistanceExtension(\StructType\ExtensionType $roadsideAssistanceExtension = null)
    {
        $this->roadsideAssistanceExtension = $roadsideAssistanceExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoadsideAssistance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
