<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoadSituationElementStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for individual PT SITUATION.
 * @subpackage Structs
 */
class RoadSituationElementStructure extends SituationElementStructure
{
    /**
     * The Verification
     * Meta informations extracted from the WSDL
     * - documentation: Whether incident has been verified or not If not specified return all. | Whether the SITUATION has been verified.
     * - minOccurs: 0
     * - type: VerificationStatusEnumeration
     * @var VerificationStatusEnumeration
     */
    public $Verification;
    /**
     * The Progress
     * @var string
     */
    public $Progress;
    /**
     * The QualityIndex
     * @var string
     */
    public $QualityIndex;
    /**
     * The Reality
     * @var string
     */
    public $Reality;
    /**
     * The Likelihood
     * @var string
     */
    public $Likelihood;
    /**
     * The Publication
     * Meta informations extracted from the WSDL
     * - documentation: Type for Publication status.
     * @var string
     */
    public $Publication;
    /**
     * The ValidityPeriod
     * @var \StructType\HalfOpenTimestampOutputRangeStructure
     */
    public $ValidityPeriod;
    /**
     * The Repetitions
     * @var \StructType\Repetitions
     */
    public $Repetitions;
    /**
     * The PublicationWindow
     * @var \StructType\HalfOpenTimestampOutputRangeStructure
     */
    public $PublicationWindow;
    /**
     * The UnknownReason
     * @var string
     */
    public $UnknownReason;
    /**
     * The MiscellaneousReason
     * @var string
     */
    public $MiscellaneousReason;
    /**
     * The PersonnelReason
     * @var string
     */
    public $PersonnelReason;
    /**
     * The EquipmentReason
     * @var string
     */
    public $EquipmentReason;
    /**
     * The EnvironmentReason
     * @var string
     */
    public $EnvironmentReason;
    /**
     * The UndefinedReason
     * @var string
     */
    public $UndefinedReason;
    /**
     * The MiscellaneousSubReason
     * @var string
     */
    public $MiscellaneousSubReason;
    /**
     * The PersonnelSubReason
     * @var string
     */
    public $PersonnelSubReason;
    /**
     * The EquipmentSubReason
     * @var string
     */
    public $EquipmentSubReason;
    /**
     * The EnvironmentSubReason
     * @var string
     */
    public $EnvironmentSubReason;
    /**
     * The PublicEventReason
     * @var string
     */
    public $PublicEventReason;
    /**
     * The ReasonName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $ReasonName;
    /**
     * The Severity
     * @var string
     */
    public $Severity;
    /**
     * The Priority
     * @var int
     */
    public $Priority;
    /**
     * The Sensitivity
     * @var string
     */
    public $Sensitivity;
    /**
     * The Audience
     * @var string
     */
    public $Audience;
    /**
     * The ScopeType
     * Meta informations extracted from the WSDL
     * - documentation: Nature of scope, e.g. general, network.
     * - minOccurs: 0
     * @var ScopeTypeEnumeration
     */
    public $ScopeType;
    /**
     * The ReportType
     * @var string
     */
    public $ReportType;
    /**
     * The Planned
     * @var bool
     */
    public $Planned;
    /**
     * The Keywords
     * @var string
     */
    public $Keywords;
    /**
     * The SecondaryReasons
     * @var \StructType\SecondaryReasons
     */
    public $SecondaryReasons;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The Summary
     * @var \StructType\DefaultedTextStructure
     */
    public $Summary;
    /**
     * The Description
     * @var \StructType\DefaultedTextStructure
     */
    public $Description;
    /**
     * The Detail
     * @var \StructType\DefaultedTextStructure
     */
    public $Detail;
    /**
     * The Advice
     * @var \StructType\DefaultedTextStructure
     */
    public $Advice;
    /**
     * The Internal
     * @var \StructType\DefaultedTextStructure
     */
    public $Internal;
    /**
     * The Images
     * @var \StructType\Images
     */
    public $Images;
    /**
     * The InfoLinks
     * @var \StructType\InfoLinks
     */
    public $InfoLinks;
    /**
     * The Affects
     * @var \StructType\AffectsScopeStructure
     */
    public $Affects;
    /**
     * The Consequences
     * @var \StructType\PtConsequencesStructure
     */
    public $Consequences;
    /**
     * The PublishingActions
     * @var \StructType\ActionsStructure
     */
    public $PublishingActions;
    /**
     * The SituationRecord
     * @var \StructType\SituationRecord
     */
    public $SituationRecord;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for RoadSituationElementStructure
     * @uses RoadSituationElementStructure::setVerification()
     * @uses RoadSituationElementStructure::setProgress()
     * @uses RoadSituationElementStructure::setQualityIndex()
     * @uses RoadSituationElementStructure::setReality()
     * @uses RoadSituationElementStructure::setLikelihood()
     * @uses RoadSituationElementStructure::setPublication()
     * @uses RoadSituationElementStructure::setValidityPeriod()
     * @uses RoadSituationElementStructure::setRepetitions()
     * @uses RoadSituationElementStructure::setPublicationWindow()
     * @uses RoadSituationElementStructure::setUnknownReason()
     * @uses RoadSituationElementStructure::setMiscellaneousReason()
     * @uses RoadSituationElementStructure::setPersonnelReason()
     * @uses RoadSituationElementStructure::setEquipmentReason()
     * @uses RoadSituationElementStructure::setEnvironmentReason()
     * @uses RoadSituationElementStructure::setUndefinedReason()
     * @uses RoadSituationElementStructure::setMiscellaneousSubReason()
     * @uses RoadSituationElementStructure::setPersonnelSubReason()
     * @uses RoadSituationElementStructure::setEquipmentSubReason()
     * @uses RoadSituationElementStructure::setEnvironmentSubReason()
     * @uses RoadSituationElementStructure::setPublicEventReason()
     * @uses RoadSituationElementStructure::setReasonName()
     * @uses RoadSituationElementStructure::setSeverity()
     * @uses RoadSituationElementStructure::setPriority()
     * @uses RoadSituationElementStructure::setSensitivity()
     * @uses RoadSituationElementStructure::setAudience()
     * @uses RoadSituationElementStructure::setScopeType()
     * @uses RoadSituationElementStructure::setReportType()
     * @uses RoadSituationElementStructure::setPlanned()
     * @uses RoadSituationElementStructure::setKeywords()
     * @uses RoadSituationElementStructure::setSecondaryReasons()
     * @uses RoadSituationElementStructure::setLanguage()
     * @uses RoadSituationElementStructure::setSummary()
     * @uses RoadSituationElementStructure::setDescription()
     * @uses RoadSituationElementStructure::setDetail()
     * @uses RoadSituationElementStructure::setAdvice()
     * @uses RoadSituationElementStructure::setInternal()
     * @uses RoadSituationElementStructure::setImages()
     * @uses RoadSituationElementStructure::setInfoLinks()
     * @uses RoadSituationElementStructure::setAffects()
     * @uses RoadSituationElementStructure::setConsequences()
     * @uses RoadSituationElementStructure::setPublishingActions()
     * @uses RoadSituationElementStructure::setSituationRecord()
     * @uses RoadSituationElementStructure::setExtensions()
     * @param VerificationStatusEnumeration $verification
     * @param string $progress
     * @param string $qualityIndex
     * @param string $reality
     * @param string $likelihood
     * @param string $publication
     * @param \StructType\HalfOpenTimestampOutputRangeStructure $validityPeriod
     * @param \StructType\Repetitions $repetitions
     * @param \StructType\HalfOpenTimestampOutputRangeStructure $publicationWindow
     * @param string $unknownReason
     * @param string $miscellaneousReason
     * @param string $personnelReason
     * @param string $equipmentReason
     * @param string $environmentReason
     * @param string $undefinedReason
     * @param string $miscellaneousSubReason
     * @param string $personnelSubReason
     * @param string $equipmentSubReason
     * @param string $environmentSubReason
     * @param string $publicEventReason
     * @param \StructType\NaturalLanguageStringStructure $reasonName
     * @param string $severity
     * @param int $priority
     * @param string $sensitivity
     * @param string $audience
     * @param ScopeTypeEnumeration $scopeType
     * @param string $reportType
     * @param bool $planned
     * @param string $keywords
     * @param \StructType\SecondaryReasons $secondaryReasons
     * @param string $language
     * @param \StructType\DefaultedTextStructure $summary
     * @param \StructType\DefaultedTextStructure $description
     * @param \StructType\DefaultedTextStructure $detail
     * @param \StructType\DefaultedTextStructure $advice
     * @param \StructType\DefaultedTextStructure $internal
     * @param \StructType\Images $images
     * @param \StructType\InfoLinks $infoLinks
     * @param \StructType\AffectsScopeStructure $affects
     * @param \StructType\PtConsequencesStructure $consequences
     * @param \StructType\ActionsStructure $publishingActions
     * @param \StructType\SituationRecord $situationRecord
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(VerificationStatusEnumeration $verification = null, $progress = null, $qualityIndex = null, $reality = null, $likelihood = null, $publication = null, \StructType\HalfOpenTimestampOutputRangeStructure $validityPeriod = null, \StructType\Repetitions $repetitions = null, \StructType\HalfOpenTimestampOutputRangeStructure $publicationWindow = null, $unknownReason = null, $miscellaneousReason = null, $personnelReason = null, $equipmentReason = null, $environmentReason = null, $undefinedReason = null, $miscellaneousSubReason = null, $personnelSubReason = null, $equipmentSubReason = null, $environmentSubReason = null, $publicEventReason = null, \StructType\NaturalLanguageStringStructure $reasonName = null, $severity = null, $priority = null, $sensitivity = null, $audience = null, ScopeTypeEnumeration $scopeType = null, $reportType = null, $planned = null, $keywords = null, \StructType\SecondaryReasons $secondaryReasons = null, $language = null, \StructType\DefaultedTextStructure $summary = null, \StructType\DefaultedTextStructure $description = null, \StructType\DefaultedTextStructure $detail = null, \StructType\DefaultedTextStructure $advice = null, \StructType\DefaultedTextStructure $internal = null, \StructType\Images $images = null, \StructType\InfoLinks $infoLinks = null, \StructType\AffectsScopeStructure $affects = null, \StructType\PtConsequencesStructure $consequences = null, \StructType\ActionsStructure $publishingActions = null, \StructType\SituationRecord $situationRecord = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setVerification($verification)
            ->setProgress($progress)
            ->setQualityIndex($qualityIndex)
            ->setReality($reality)
            ->setLikelihood($likelihood)
            ->setPublication($publication)
            ->setValidityPeriod($validityPeriod)
            ->setRepetitions($repetitions)
            ->setPublicationWindow($publicationWindow)
            ->setUnknownReason($unknownReason)
            ->setMiscellaneousReason($miscellaneousReason)
            ->setPersonnelReason($personnelReason)
            ->setEquipmentReason($equipmentReason)
            ->setEnvironmentReason($environmentReason)
            ->setUndefinedReason($undefinedReason)
            ->setMiscellaneousSubReason($miscellaneousSubReason)
            ->setPersonnelSubReason($personnelSubReason)
            ->setEquipmentSubReason($equipmentSubReason)
            ->setEnvironmentSubReason($environmentSubReason)
            ->setPublicEventReason($publicEventReason)
            ->setReasonName($reasonName)
            ->setSeverity($severity)
            ->setPriority($priority)
            ->setSensitivity($sensitivity)
            ->setAudience($audience)
            ->setScopeType($scopeType)
            ->setReportType($reportType)
            ->setPlanned($planned)
            ->setKeywords($keywords)
            ->setSecondaryReasons($secondaryReasons)
            ->setLanguage($language)
            ->setSummary($summary)
            ->setDescription($description)
            ->setDetail($detail)
            ->setAdvice($advice)
            ->setInternal($internal)
            ->setImages($images)
            ->setInfoLinks($infoLinks)
            ->setAffects($affects)
            ->setConsequences($consequences)
            ->setPublishingActions($publishingActions)
            ->setSituationRecord($situationRecord)
            ->setExtensions($extensions);
    }
    /**
     * Get Verification value
     * @return VerificationStatusEnumeration|null
     */
    public function getVerification()
    {
        return $this->Verification;
    }
    /**
     * Set Verification value
     * @param VerificationStatusEnumeration $verification
     * @return \StructType\RoadSituationElementStructure
     */
    public function setVerification(VerificationStatusEnumeration $verification = null)
    {
        $this->Verification = $verification;
        return $this;
    }
    /**
     * Get Progress value
     * @return string|null
     */
    public function getProgress()
    {
        return $this->Progress;
    }
    /**
     * Set Progress value
     * @uses \EnumType\WorkflowStatusEnumeration::valueIsValid()
     * @uses \EnumType\WorkflowStatusEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $progress
     * @return \StructType\RoadSituationElementStructure
     */
    public function setProgress($progress = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WorkflowStatusEnumeration::valueIsValid($progress)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $progress, implode(', ', \EnumType\WorkflowStatusEnumeration::getValidValues())), __LINE__);
        }
        $this->Progress = $progress;
        return $this;
    }
    /**
     * Get QualityIndex value
     * @return string|null
     */
    public function getQualityIndex()
    {
        return $this->QualityIndex;
    }
    /**
     * Set QualityIndex value
     * @uses \EnumType\QualityEnumeration::valueIsValid()
     * @uses \EnumType\QualityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qualityIndex
     * @return \StructType\RoadSituationElementStructure
     */
    public function setQualityIndex($qualityIndex = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QualityEnumeration::valueIsValid($qualityIndex)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $qualityIndex, implode(', ', \EnumType\QualityEnumeration::getValidValues())), __LINE__);
        }
        $this->QualityIndex = $qualityIndex;
        return $this;
    }
    /**
     * Get Reality value
     * @return string|null
     */
    public function getReality()
    {
        return $this->Reality;
    }
    /**
     * Set Reality value
     * @uses \EnumType\InformationStatusEnum::valueIsValid()
     * @uses \EnumType\InformationStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reality
     * @return \StructType\RoadSituationElementStructure
     */
    public function setReality($reality = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InformationStatusEnum::valueIsValid($reality)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $reality, implode(', ', \EnumType\InformationStatusEnum::getValidValues())), __LINE__);
        }
        $this->Reality = $reality;
        return $this;
    }
    /**
     * Get Likelihood value
     * @return string|null
     */
    public function getLikelihood()
    {
        return $this->Likelihood;
    }
    /**
     * Set Likelihood value
     * @uses \EnumType\ProbabilityOfOccurrenceEnum::valueIsValid()
     * @uses \EnumType\ProbabilityOfOccurrenceEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $likelihood
     * @return \StructType\RoadSituationElementStructure
     */
    public function setLikelihood($likelihood = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProbabilityOfOccurrenceEnum::valueIsValid($likelihood)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $likelihood, implode(', ', \EnumType\ProbabilityOfOccurrenceEnum::getValidValues())), __LINE__);
        }
        $this->Likelihood = $likelihood;
        return $this;
    }
    /**
     * Get Publication value
     * @return string|null
     */
    public function getPublication()
    {
        return $this->Publication;
    }
    /**
     * Set Publication value
     * @param string $publication
     * @return \StructType\RoadSituationElementStructure
     */
    public function setPublication($publication = null)
    {
        // validation for constraint: string
        if (!is_null($publication) && !is_string($publication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($publication)), __LINE__);
        }
        $this->Publication = $publication;
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * @return \StructType\HalfOpenTimestampOutputRangeStructure|null
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }
    /**
     * Set ValidityPeriod value
     * @param \StructType\HalfOpenTimestampOutputRangeStructure $validityPeriod
     * @return \StructType\RoadSituationElementStructure
     */
    public function setValidityPeriod(\StructType\HalfOpenTimestampOutputRangeStructure $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }
    /**
     * Get Repetitions value
     * @return \StructType\Repetitions|null
     */
    public function getRepetitions()
    {
        return $this->Repetitions;
    }
    /**
     * Set Repetitions value
     * @param \StructType\Repetitions $repetitions
     * @return \StructType\RoadSituationElementStructure
     */
    public function setRepetitions(\StructType\Repetitions $repetitions = null)
    {
        $this->Repetitions = $repetitions;
        return $this;
    }
    /**
     * Get PublicationWindow value
     * @return \StructType\HalfOpenTimestampOutputRangeStructure|null
     */
    public function getPublicationWindow()
    {
        return $this->PublicationWindow;
    }
    /**
     * Set PublicationWindow value
     * @param \StructType\HalfOpenTimestampOutputRangeStructure $publicationWindow
     * @return \StructType\RoadSituationElementStructure
     */
    public function setPublicationWindow(\StructType\HalfOpenTimestampOutputRangeStructure $publicationWindow = null)
    {
        $this->PublicationWindow = $publicationWindow;
        return $this;
    }
    /**
     * Get UnknownReason value
     * @return string|null
     */
    public function getUnknownReason()
    {
        return $this->UnknownReason;
    }
    /**
     * Set UnknownReason value
     * @param string $unknownReason
     * @return \StructType\RoadSituationElementStructure
     */
    public function setUnknownReason($unknownReason = null)
    {
        // validation for constraint: string
        if (!is_null($unknownReason) && !is_string($unknownReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unknownReason)), __LINE__);
        }
        $this->UnknownReason = $unknownReason;
        return $this;
    }
    /**
     * Get MiscellaneousReason value
     * @return string|null
     */
    public function getMiscellaneousReason()
    {
        return $this->MiscellaneousReason;
    }
    /**
     * Set MiscellaneousReason value
     * @uses \EnumType\MiscellaneousReasonEnumeration::valueIsValid()
     * @uses \EnumType\MiscellaneousReasonEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $miscellaneousReason
     * @return \StructType\RoadSituationElementStructure
     */
    public function setMiscellaneousReason($miscellaneousReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MiscellaneousReasonEnumeration::valueIsValid($miscellaneousReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $miscellaneousReason, implode(', ', \EnumType\MiscellaneousReasonEnumeration::getValidValues())), __LINE__);
        }
        $this->MiscellaneousReason = $miscellaneousReason;
        return $this;
    }
    /**
     * Get PersonnelReason value
     * @return string|null
     */
    public function getPersonnelReason()
    {
        return $this->PersonnelReason;
    }
    /**
     * Set PersonnelReason value
     * @uses \EnumType\PersonnelReasonEnumeration::valueIsValid()
     * @uses \EnumType\PersonnelReasonEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $personnelReason
     * @return \StructType\RoadSituationElementStructure
     */
    public function setPersonnelReason($personnelReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PersonnelReasonEnumeration::valueIsValid($personnelReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $personnelReason, implode(', ', \EnumType\PersonnelReasonEnumeration::getValidValues())), __LINE__);
        }
        $this->PersonnelReason = $personnelReason;
        return $this;
    }
    /**
     * Get EquipmentReason value
     * @return string|null
     */
    public function getEquipmentReason()
    {
        return $this->EquipmentReason;
    }
    /**
     * Set EquipmentReason value
     * @uses \EnumType\EquipmentReasonEnumeration::valueIsValid()
     * @uses \EnumType\EquipmentReasonEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $equipmentReason
     * @return \StructType\RoadSituationElementStructure
     */
    public function setEquipmentReason($equipmentReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EquipmentReasonEnumeration::valueIsValid($equipmentReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $equipmentReason, implode(', ', \EnumType\EquipmentReasonEnumeration::getValidValues())), __LINE__);
        }
        $this->EquipmentReason = $equipmentReason;
        return $this;
    }
    /**
     * Get EnvironmentReason value
     * @return string|null
     */
    public function getEnvironmentReason()
    {
        return $this->EnvironmentReason;
    }
    /**
     * Set EnvironmentReason value
     * @uses \EnumType\EnvironmentReasonEnumeration::valueIsValid()
     * @uses \EnumType\EnvironmentReasonEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $environmentReason
     * @return \StructType\RoadSituationElementStructure
     */
    public function setEnvironmentReason($environmentReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnvironmentReasonEnumeration::valueIsValid($environmentReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $environmentReason, implode(', ', \EnumType\EnvironmentReasonEnumeration::getValidValues())), __LINE__);
        }
        $this->EnvironmentReason = $environmentReason;
        return $this;
    }
    /**
     * Get UndefinedReason value
     * @return string|null
     */
    public function getUndefinedReason()
    {
        return $this->UndefinedReason;
    }
    /**
     * Set UndefinedReason value
     * @param string $undefinedReason
     * @return \StructType\RoadSituationElementStructure
     */
    public function setUndefinedReason($undefinedReason = null)
    {
        // validation for constraint: string
        if (!is_null($undefinedReason) && !is_string($undefinedReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($undefinedReason)), __LINE__);
        }
        $this->UndefinedReason = $undefinedReason;
        return $this;
    }
    /**
     * Get MiscellaneousSubReason value
     * @return string|null
     */
    public function getMiscellaneousSubReason()
    {
        return $this->MiscellaneousSubReason;
    }
    /**
     * Set MiscellaneousSubReason value
     * @uses \EnumType\MiscellaneousSubReasonEnumeration::valueIsValid()
     * @uses \EnumType\MiscellaneousSubReasonEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $miscellaneousSubReason
     * @return \StructType\RoadSituationElementStructure
     */
    public function setMiscellaneousSubReason($miscellaneousSubReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MiscellaneousSubReasonEnumeration::valueIsValid($miscellaneousSubReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $miscellaneousSubReason, implode(', ', \EnumType\MiscellaneousSubReasonEnumeration::getValidValues())), __LINE__);
        }
        $this->MiscellaneousSubReason = $miscellaneousSubReason;
        return $this;
    }
    /**
     * Get PersonnelSubReason value
     * @return string|null
     */
    public function getPersonnelSubReason()
    {
        return $this->PersonnelSubReason;
    }
    /**
     * Set PersonnelSubReason value
     * @uses \EnumType\PersonnelSubReasonEnumeration::valueIsValid()
     * @uses \EnumType\PersonnelSubReasonEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $personnelSubReason
     * @return \StructType\RoadSituationElementStructure
     */
    public function setPersonnelSubReason($personnelSubReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PersonnelSubReasonEnumeration::valueIsValid($personnelSubReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $personnelSubReason, implode(', ', \EnumType\PersonnelSubReasonEnumeration::getValidValues())), __LINE__);
        }
        $this->PersonnelSubReason = $personnelSubReason;
        return $this;
    }
    /**
     * Get EquipmentSubReason value
     * @return string|null
     */
    public function getEquipmentSubReason()
    {
        return $this->EquipmentSubReason;
    }
    /**
     * Set EquipmentSubReason value
     * @uses \EnumType\EquipmentSubReasonEnumeration::valueIsValid()
     * @uses \EnumType\EquipmentSubReasonEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $equipmentSubReason
     * @return \StructType\RoadSituationElementStructure
     */
    public function setEquipmentSubReason($equipmentSubReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EquipmentSubReasonEnumeration::valueIsValid($equipmentSubReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $equipmentSubReason, implode(', ', \EnumType\EquipmentSubReasonEnumeration::getValidValues())), __LINE__);
        }
        $this->EquipmentSubReason = $equipmentSubReason;
        return $this;
    }
    /**
     * Get EnvironmentSubReason value
     * @return string|null
     */
    public function getEnvironmentSubReason()
    {
        return $this->EnvironmentSubReason;
    }
    /**
     * Set EnvironmentSubReason value
     * @uses \EnumType\EnvironmentSubReasonEnumeration::valueIsValid()
     * @uses \EnumType\EnvironmentSubReasonEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $environmentSubReason
     * @return \StructType\RoadSituationElementStructure
     */
    public function setEnvironmentSubReason($environmentSubReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnvironmentSubReasonEnumeration::valueIsValid($environmentSubReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $environmentSubReason, implode(', ', \EnumType\EnvironmentSubReasonEnumeration::getValidValues())), __LINE__);
        }
        $this->EnvironmentSubReason = $environmentSubReason;
        return $this;
    }
    /**
     * Get PublicEventReason value
     * @return string|null
     */
    public function getPublicEventReason()
    {
        return $this->PublicEventReason;
    }
    /**
     * Set PublicEventReason value
     * @uses \EnumType\PublicEventTypeEnum::valueIsValid()
     * @uses \EnumType\PublicEventTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $publicEventReason
     * @return \StructType\RoadSituationElementStructure
     */
    public function setPublicEventReason($publicEventReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PublicEventTypeEnum::valueIsValid($publicEventReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $publicEventReason, implode(', ', \EnumType\PublicEventTypeEnum::getValidValues())), __LINE__);
        }
        $this->PublicEventReason = $publicEventReason;
        return $this;
    }
    /**
     * Get ReasonName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getReasonName()
    {
        return $this->ReasonName;
    }
    /**
     * Set ReasonName value
     * @param \StructType\NaturalLanguageStringStructure $reasonName
     * @return \StructType\RoadSituationElementStructure
     */
    public function setReasonName(\StructType\NaturalLanguageStringStructure $reasonName = null)
    {
        $this->ReasonName = $reasonName;
        return $this;
    }
    /**
     * Get Severity value
     * @return string|null
     */
    public function getSeverity()
    {
        return $this->Severity;
    }
    /**
     * Set Severity value
     * @uses \EnumType\SeverityEnumeration::valueIsValid()
     * @uses \EnumType\SeverityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $severity
     * @return \StructType\RoadSituationElementStructure
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SeverityEnumeration::valueIsValid($severity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $severity, implode(', ', \EnumType\SeverityEnumeration::getValidValues())), __LINE__);
        }
        $this->Severity = $severity;
        return $this;
    }
    /**
     * Get Priority value
     * @return int|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param int $priority
     * @return \StructType\RoadSituationElementStructure
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !is_numeric($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($priority)), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get Sensitivity value
     * @return string|null
     */
    public function getSensitivity()
    {
        return $this->Sensitivity;
    }
    /**
     * Set Sensitivity value
     * @uses \EnumType\SensitivityEnumeration::valueIsValid()
     * @uses \EnumType\SensitivityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sensitivity
     * @return \StructType\RoadSituationElementStructure
     */
    public function setSensitivity($sensitivity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SensitivityEnumeration::valueIsValid($sensitivity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sensitivity, implode(', ', \EnumType\SensitivityEnumeration::getValidValues())), __LINE__);
        }
        $this->Sensitivity = $sensitivity;
        return $this;
    }
    /**
     * Get Audience value
     * @return string|null
     */
    public function getAudience()
    {
        return $this->Audience;
    }
    /**
     * Set Audience value
     * @uses \EnumType\AudienceEnumeration::valueIsValid()
     * @uses \EnumType\AudienceEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $audience
     * @return \StructType\RoadSituationElementStructure
     */
    public function setAudience($audience = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AudienceEnumeration::valueIsValid($audience)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $audience, implode(', ', \EnumType\AudienceEnumeration::getValidValues())), __LINE__);
        }
        $this->Audience = $audience;
        return $this;
    }
    /**
     * Get ScopeType value
     * @return ScopeTypeEnumeration|null
     */
    public function getScopeType()
    {
        return $this->ScopeType;
    }
    /**
     * Set ScopeType value
     * @param ScopeTypeEnumeration $scopeType
     * @return \StructType\RoadSituationElementStructure
     */
    public function setScopeType(ScopeTypeEnumeration $scopeType = null)
    {
        $this->ScopeType = $scopeType;
        return $this;
    }
    /**
     * Get ReportType value
     * @return string|null
     */
    public function getReportType()
    {
        return $this->ReportType;
    }
    /**
     * Set ReportType value
     * @uses \EnumType\ReportTypeEnumeration::valueIsValid()
     * @uses \EnumType\ReportTypeEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reportType
     * @return \StructType\RoadSituationElementStructure
     */
    public function setReportType($reportType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReportTypeEnumeration::valueIsValid($reportType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $reportType, implode(', ', \EnumType\ReportTypeEnumeration::getValidValues())), __LINE__);
        }
        $this->ReportType = $reportType;
        return $this;
    }
    /**
     * Get Planned value
     * @return bool|null
     */
    public function getPlanned()
    {
        return $this->Planned;
    }
    /**
     * Set Planned value
     * @param bool $planned
     * @return \StructType\RoadSituationElementStructure
     */
    public function setPlanned($planned = null)
    {
        // validation for constraint: boolean
        if (!is_null($planned) && !is_bool($planned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($planned)), __LINE__);
        }
        $this->Planned = $planned;
        return $this;
    }
    /**
     * Get Keywords value
     * @return string|null
     */
    public function getKeywords()
    {
        return $this->Keywords;
    }
    /**
     * Set Keywords value
     * @param string $keywords
     * @return \StructType\RoadSituationElementStructure
     */
    public function setKeywords($keywords = null)
    {
        // validation for constraint: string
        if (!is_null($keywords) && !is_string($keywords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keywords)), __LINE__);
        }
        $this->Keywords = $keywords;
        return $this;
    }
    /**
     * Get SecondaryReasons value
     * @return \StructType\SecondaryReasons|null
     */
    public function getSecondaryReasons()
    {
        return $this->SecondaryReasons;
    }
    /**
     * Set SecondaryReasons value
     * @param \StructType\SecondaryReasons $secondaryReasons
     * @return \StructType\RoadSituationElementStructure
     */
    public function setSecondaryReasons(\StructType\SecondaryReasons $secondaryReasons = null)
    {
        $this->SecondaryReasons = $secondaryReasons;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\RoadSituationElementStructure
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Summary value
     * @return \StructType\DefaultedTextStructure|null
     */
    public function getSummary()
    {
        return $this->Summary;
    }
    /**
     * Set Summary value
     * @param \StructType\DefaultedTextStructure $summary
     * @return \StructType\RoadSituationElementStructure
     */
    public function setSummary(\StructType\DefaultedTextStructure $summary = null)
    {
        $this->Summary = $summary;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\DefaultedTextStructure|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\DefaultedTextStructure $description
     * @return \StructType\RoadSituationElementStructure
     */
    public function setDescription(\StructType\DefaultedTextStructure $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Detail value
     * @return \StructType\DefaultedTextStructure|null
     */
    public function getDetail()
    {
        return $this->Detail;
    }
    /**
     * Set Detail value
     * @param \StructType\DefaultedTextStructure $detail
     * @return \StructType\RoadSituationElementStructure
     */
    public function setDetail(\StructType\DefaultedTextStructure $detail = null)
    {
        $this->Detail = $detail;
        return $this;
    }
    /**
     * Get Advice value
     * @return \StructType\DefaultedTextStructure|null
     */
    public function getAdvice()
    {
        return $this->Advice;
    }
    /**
     * Set Advice value
     * @param \StructType\DefaultedTextStructure $advice
     * @return \StructType\RoadSituationElementStructure
     */
    public function setAdvice(\StructType\DefaultedTextStructure $advice = null)
    {
        $this->Advice = $advice;
        return $this;
    }
    /**
     * Get Internal value
     * @return \StructType\DefaultedTextStructure|null
     */
    public function getInternal()
    {
        return $this->Internal;
    }
    /**
     * Set Internal value
     * @param \StructType\DefaultedTextStructure $internal
     * @return \StructType\RoadSituationElementStructure
     */
    public function setInternal(\StructType\DefaultedTextStructure $internal = null)
    {
        $this->Internal = $internal;
        return $this;
    }
    /**
     * Get Images value
     * @return \StructType\Images|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \StructType\Images $images
     * @return \StructType\RoadSituationElementStructure
     */
    public function setImages(\StructType\Images $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get InfoLinks value
     * @return \StructType\InfoLinks|null
     */
    public function getInfoLinks()
    {
        return $this->InfoLinks;
    }
    /**
     * Set InfoLinks value
     * @param \StructType\InfoLinks $infoLinks
     * @return \StructType\RoadSituationElementStructure
     */
    public function setInfoLinks(\StructType\InfoLinks $infoLinks = null)
    {
        $this->InfoLinks = $infoLinks;
        return $this;
    }
    /**
     * Get Affects value
     * @return \StructType\AffectsScopeStructure|null
     */
    public function getAffects()
    {
        return $this->Affects;
    }
    /**
     * Set Affects value
     * @param \StructType\AffectsScopeStructure $affects
     * @return \StructType\RoadSituationElementStructure
     */
    public function setAffects(\StructType\AffectsScopeStructure $affects = null)
    {
        $this->Affects = $affects;
        return $this;
    }
    /**
     * Get Consequences value
     * @return \StructType\PtConsequencesStructure|null
     */
    public function getConsequences()
    {
        return $this->Consequences;
    }
    /**
     * Set Consequences value
     * @param \StructType\PtConsequencesStructure $consequences
     * @return \StructType\RoadSituationElementStructure
     */
    public function setConsequences(\StructType\PtConsequencesStructure $consequences = null)
    {
        $this->Consequences = $consequences;
        return $this;
    }
    /**
     * Get PublishingActions value
     * @return \StructType\ActionsStructure|null
     */
    public function getPublishingActions()
    {
        return $this->PublishingActions;
    }
    /**
     * Set PublishingActions value
     * @param \StructType\ActionsStructure $publishingActions
     * @return \StructType\RoadSituationElementStructure
     */
    public function setPublishingActions(\StructType\ActionsStructure $publishingActions = null)
    {
        $this->PublishingActions = $publishingActions;
        return $this;
    }
    /**
     * Get SituationRecord value
     * @return \StructType\SituationRecord|null
     */
    public function getSituationRecord()
    {
        return $this->SituationRecord;
    }
    /**
     * Set SituationRecord value
     * @param \StructType\SituationRecord $situationRecord
     * @return \StructType\RoadSituationElementStructure
     */
    public function setSituationRecord(\StructType\SituationRecord $situationRecord = null)
    {
        $this->SituationRecord = $situationRecord;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\RoadSituationElementStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoadSituationElementStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
