<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoadFilterStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Parameters to filter Situation Exchange Service requests, based on the SITUATION Road, Logically ANDed with other values.
 * @subpackage Structs
 */
class RoadFilterStructure extends AbstractStructBase
{
    /**
     * The roadNumber
     * Meta informations extracted from the WSDL
     * - documentation: Identifier or number of the road on which the reference POINT is located.
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $roadNumber;
    /**
     * The directionBound
     * Meta informations extracted from the WSDL
     * - documentation: The DIRECTION at the reference point in terms of general destination DIRECTION. If absent both.
     * - minOccurs: 0
     * @var string
     */
    public $directionBound;
    /**
     * The referencePointIdentifier
     * Meta informations extracted from the WSDL
     * - documentation: Road reference POINT identifier, unique on the specified road.
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $referencePointIdentifier;
    /**
     * Constructor method for RoadFilterStructure
     * @uses RoadFilterStructure::setRoadNumber()
     * @uses RoadFilterStructure::setDirectionBound()
     * @uses RoadFilterStructure::setReferencePointIdentifier()
     * @param string $roadNumber
     * @param string $directionBound
     * @param string $referencePointIdentifier
     */
    public function __construct($roadNumber = null, $directionBound = null, $referencePointIdentifier = null)
    {
        $this
            ->setRoadNumber($roadNumber)
            ->setDirectionBound($directionBound)
            ->setReferencePointIdentifier($referencePointIdentifier);
    }
    /**
     * Get roadNumber value
     * @return string|null
     */
    public function getRoadNumber()
    {
        return $this->roadNumber;
    }
    /**
     * Set roadNumber value
     * @param string $roadNumber
     * @return \StructType\RoadFilterStructure
     */
    public function setRoadNumber($roadNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($roadNumber) && strlen($roadNumber) > 1024) || (is_array($roadNumber) && count($roadNumber) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($roadNumber) ? strlen($roadNumber) : count($roadNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($roadNumber) && !is_string($roadNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roadNumber)), __LINE__);
        }
        $this->roadNumber = $roadNumber;
        return $this;
    }
    /**
     * Get directionBound value
     * @return string|null
     */
    public function getDirectionBound()
    {
        return $this->directionBound;
    }
    /**
     * Set directionBound value
     * @uses \EnumType\DirectionEnum::valueIsValid()
     * @uses \EnumType\DirectionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $directionBound
     * @return \StructType\RoadFilterStructure
     */
    public function setDirectionBound($directionBound = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DirectionEnum::valueIsValid($directionBound)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $directionBound, implode(', ', \EnumType\DirectionEnum::getValidValues())), __LINE__);
        }
        $this->directionBound = $directionBound;
        return $this;
    }
    /**
     * Get referencePointIdentifier value
     * @return string|null
     */
    public function getReferencePointIdentifier()
    {
        return $this->referencePointIdentifier;
    }
    /**
     * Set referencePointIdentifier value
     * @param string $referencePointIdentifier
     * @return \StructType\RoadFilterStructure
     */
    public function setReferencePointIdentifier($referencePointIdentifier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($referencePointIdentifier) && strlen($referencePointIdentifier) > 1024) || (is_array($referencePointIdentifier) && count($referencePointIdentifier) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($referencePointIdentifier) ? strlen($referencePointIdentifier) : count($referencePointIdentifier)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($referencePointIdentifier) && !is_string($referencePointIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referencePointIdentifier)), __LINE__);
        }
        $this->referencePointIdentifier = $referencePointIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoadFilterStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
