<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: General Type for General SIRI Response.
 * @subpackage Structs
 */
abstract class ResponseStructure extends AbstractStructBase
{
    /**
     * The ResponseTimestamp
     * Meta informations extracted from the WSDL
     * - ref: ResponseTimestamp
     * @var string
     */
    public $ResponseTimestamp;
    /**
     * Constructor method for ResponseStructure
     * @uses ResponseStructure::setResponseTimestamp()
     * @param string $responseTimestamp
     */
    public function __construct($responseTimestamp = null)
    {
        $this
            ->setResponseTimestamp($responseTimestamp);
    }
    /**
     * Get ResponseTimestamp value
     * @return string|null
     */
    public function getResponseTimestamp()
    {
        return $this->ResponseTimestamp;
    }
    /**
     * Set ResponseTimestamp value
     * @param string $responseTimestamp
     * @return \StructType\ResponseStructure
     */
    public function setResponseTimestamp($responseTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($responseTimestamp) && !is_string($responseTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseTimestamp)), __LINE__);
        }
        $this->ResponseTimestamp = $responseTimestamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResponseStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
