<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseFeatures StructType
 * Meta informations extracted from the WSDL
 * - documentation: Available Optional Response capabilities. | Optional Response capabilities. | Optional Response capabilities. | Optional Response capabilities.
 * @subpackage Structs
 */
class ResponseFeatures extends AbstractStructBase
{
    /**
     * The HasLineNotices
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether result supports LINE events. Default is 'true'.
     * - minOccurs: 0
     * @var bool
     */
    public $HasLineNotices;
    /**
     * The HasSituations
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Whether result supports SITUATION REFERENCESs. Default is 'false'. +SIRI v2.0 | Whether result supports SITUATION REFERENCESs. Default is 'false'. +SIRI v2.0
     * - minOccurs: 0
     * @var bool
     */
    public $HasSituations;
    /**
     * The HasLocation
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether result has location. Default is 'true'.
     * - minOccurs: 0
     * @var bool
     */
    public $HasLocation;
    /**
     * The HasRemedy
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Whether result supports remedy information. Default is 'false'
     * - minOccurs: 0
     * @var bool
     */
    public $HasRemedy;
    /**
     * The HasFacilityLocation
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether result supports facility location information. Default is 'true'.
     * - minOccurs: 0
     * @var bool
     */
    public $HasFacilityLocation;
    /**
     * Constructor method for ResponseFeatures
     * @uses ResponseFeatures::setHasLineNotices()
     * @uses ResponseFeatures::setHasSituations()
     * @uses ResponseFeatures::setHasLocation()
     * @uses ResponseFeatures::setHasRemedy()
     * @uses ResponseFeatures::setHasFacilityLocation()
     * @param bool $hasLineNotices
     * @param bool $hasSituations
     * @param bool $hasLocation
     * @param bool $hasRemedy
     * @param bool $hasFacilityLocation
     */
    public function __construct($hasLineNotices = true, $hasSituations = false, $hasLocation = true, $hasRemedy = false, $hasFacilityLocation = true)
    {
        $this
            ->setHasLineNotices($hasLineNotices)
            ->setHasSituations($hasSituations)
            ->setHasLocation($hasLocation)
            ->setHasRemedy($hasRemedy)
            ->setHasFacilityLocation($hasFacilityLocation);
    }
    /**
     * Get HasLineNotices value
     * @return bool|null
     */
    public function getHasLineNotices()
    {
        return $this->HasLineNotices;
    }
    /**
     * Set HasLineNotices value
     * @param bool $hasLineNotices
     * @return \StructType\ResponseFeatures
     */
    public function setHasLineNotices($hasLineNotices = true)
    {
        // validation for constraint: boolean
        if (!is_null($hasLineNotices) && !is_bool($hasLineNotices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasLineNotices)), __LINE__);
        }
        $this->HasLineNotices = $hasLineNotices;
        return $this;
    }
    /**
     * Get HasSituations value
     * @return bool|null
     */
    public function getHasSituations()
    {
        return $this->HasSituations;
    }
    /**
     * Set HasSituations value
     * @param bool $hasSituations
     * @return \StructType\ResponseFeatures
     */
    public function setHasSituations($hasSituations = false)
    {
        // validation for constraint: boolean
        if (!is_null($hasSituations) && !is_bool($hasSituations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasSituations)), __LINE__);
        }
        $this->HasSituations = $hasSituations;
        return $this;
    }
    /**
     * Get HasLocation value
     * @return bool|null
     */
    public function getHasLocation()
    {
        return $this->HasLocation;
    }
    /**
     * Set HasLocation value
     * @param bool $hasLocation
     * @return \StructType\ResponseFeatures
     */
    public function setHasLocation($hasLocation = true)
    {
        // validation for constraint: boolean
        if (!is_null($hasLocation) && !is_bool($hasLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasLocation)), __LINE__);
        }
        $this->HasLocation = $hasLocation;
        return $this;
    }
    /**
     * Get HasRemedy value
     * @return bool|null
     */
    public function getHasRemedy()
    {
        return $this->HasRemedy;
    }
    /**
     * Set HasRemedy value
     * @param bool $hasRemedy
     * @return \StructType\ResponseFeatures
     */
    public function setHasRemedy($hasRemedy = false)
    {
        // validation for constraint: boolean
        if (!is_null($hasRemedy) && !is_bool($hasRemedy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasRemedy)), __LINE__);
        }
        $this->HasRemedy = $hasRemedy;
        return $this;
    }
    /**
     * Get HasFacilityLocation value
     * @return bool|null
     */
    public function getHasFacilityLocation()
    {
        return $this->HasFacilityLocation;
    }
    /**
     * Set HasFacilityLocation value
     * @param bool $hasFacilityLocation
     * @return \StructType\ResponseFeatures
     */
    public function setHasFacilityLocation($hasFacilityLocation = true)
    {
        // validation for constraint: boolean
        if (!is_null($hasFacilityLocation) && !is_bool($hasFacilityLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasFacilityLocation)), __LINE__);
        }
        $this->HasFacilityLocation = $hasFacilityLocation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResponseFeatures
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
