<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReroutingManagement StructType
 * @subpackage Structs
 */
class ReroutingManagement extends NetworkManagement
{
    /**
     * The reroutingManagementType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $reroutingManagementType;
    /**
     * The reroutingItineraryDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $reroutingItineraryDescription;
    /**
     * The signedRerouting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $signedRerouting;
    /**
     * The entry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $entry;
    /**
     * The exit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $exit;
    /**
     * The roadOrJunctionNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $roadOrJunctionNumber;
    /**
     * The alternativeRoute
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Itinerary[]
     */
    public $alternativeRoute;
    /**
     * The reroutingManagementExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $reroutingManagementExtension;
    /**
     * Constructor method for ReroutingManagement
     * @uses ReroutingManagement::setReroutingManagementType()
     * @uses ReroutingManagement::setReroutingItineraryDescription()
     * @uses ReroutingManagement::setSignedRerouting()
     * @uses ReroutingManagement::setEntry()
     * @uses ReroutingManagement::setExit()
     * @uses ReroutingManagement::setRoadOrJunctionNumber()
     * @uses ReroutingManagement::setAlternativeRoute()
     * @uses ReroutingManagement::setReroutingManagementExtension()
     * @param string[] $reroutingManagementType
     * @param \StructType\MultilingualString $reroutingItineraryDescription
     * @param bool $signedRerouting
     * @param string $entry
     * @param string $exit
     * @param string $roadOrJunctionNumber
     * @param \StructType\Itinerary[] $alternativeRoute
     * @param \StructType\ExtensionType $reroutingManagementExtension
     */
    public function __construct(array $reroutingManagementType = array(), \StructType\MultilingualString $reroutingItineraryDescription = null, $signedRerouting = null, $entry = null, $exit = null, $roadOrJunctionNumber = null, array $alternativeRoute = array(), \StructType\ExtensionType $reroutingManagementExtension = null)
    {
        $this
            ->setReroutingManagementType($reroutingManagementType)
            ->setReroutingItineraryDescription($reroutingItineraryDescription)
            ->setSignedRerouting($signedRerouting)
            ->setEntry($entry)
            ->setExit($exit)
            ->setRoadOrJunctionNumber($roadOrJunctionNumber)
            ->setAlternativeRoute($alternativeRoute)
            ->setReroutingManagementExtension($reroutingManagementExtension);
    }
    /**
     * Get reroutingManagementType value
     * @return string[]
     */
    public function getReroutingManagementType()
    {
        return $this->reroutingManagementType;
    }
    /**
     * Set reroutingManagementType value
     * @uses \EnumType\ReroutingManagementTypeEnum::valueIsValid()
     * @uses \EnumType\ReroutingManagementTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $reroutingManagementType
     * @return \StructType\ReroutingManagement
     */
    public function setReroutingManagementType(array $reroutingManagementType = array())
    {
        $invalidValues = array();
        foreach ($reroutingManagementType as $reroutingManagementReroutingManagementTypeItem) {
            if (!\EnumType\ReroutingManagementTypeEnum::valueIsValid($reroutingManagementReroutingManagementTypeItem)) {
                $invalidValues[] = var_export($reroutingManagementReroutingManagementTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\ReroutingManagementTypeEnum::getValidValues())), __LINE__);
        }
        $this->reroutingManagementType = $reroutingManagementType;
        return $this;
    }
    /**
     * Add item to reroutingManagementType value
     * @uses \EnumType\ReroutingManagementTypeEnum::valueIsValid()
     * @uses \EnumType\ReroutingManagementTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ReroutingManagement
     */
    public function addToReroutingManagementType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReroutingManagementTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\ReroutingManagementTypeEnum::getValidValues())), __LINE__);
        }
        $this->reroutingManagementType[] = $item;
        return $this;
    }
    /**
     * Get reroutingItineraryDescription value
     * @return \StructType\MultilingualString|null
     */
    public function getReroutingItineraryDescription()
    {
        return $this->reroutingItineraryDescription;
    }
    /**
     * Set reroutingItineraryDescription value
     * @param \StructType\MultilingualString $reroutingItineraryDescription
     * @return \StructType\ReroutingManagement
     */
    public function setReroutingItineraryDescription(\StructType\MultilingualString $reroutingItineraryDescription = null)
    {
        $this->reroutingItineraryDescription = $reroutingItineraryDescription;
        return $this;
    }
    /**
     * Get signedRerouting value
     * @return bool|null
     */
    public function getSignedRerouting()
    {
        return $this->signedRerouting;
    }
    /**
     * Set signedRerouting value
     * @param bool $signedRerouting
     * @return \StructType\ReroutingManagement
     */
    public function setSignedRerouting($signedRerouting = null)
    {
        // validation for constraint: boolean
        if (!is_null($signedRerouting) && !is_bool($signedRerouting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($signedRerouting)), __LINE__);
        }
        $this->signedRerouting = $signedRerouting;
        return $this;
    }
    /**
     * Get entry value
     * @return string|null
     */
    public function getEntry()
    {
        return $this->entry;
    }
    /**
     * Set entry value
     * @param string $entry
     * @return \StructType\ReroutingManagement
     */
    public function setEntry($entry = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($entry) && strlen($entry) > 1024) || (is_array($entry) && count($entry) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($entry) ? strlen($entry) : count($entry)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($entry) && !is_string($entry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entry)), __LINE__);
        }
        $this->entry = $entry;
        return $this;
    }
    /**
     * Get exit value
     * @return string|null
     */
    public function getExit()
    {
        return $this->exit;
    }
    /**
     * Set exit value
     * @param string $exit
     * @return \StructType\ReroutingManagement
     */
    public function setExit($exit = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($exit) && strlen($exit) > 1024) || (is_array($exit) && count($exit) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($exit) ? strlen($exit) : count($exit)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($exit) && !is_string($exit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exit)), __LINE__);
        }
        $this->exit = $exit;
        return $this;
    }
    /**
     * Get roadOrJunctionNumber value
     * @return string|null
     */
    public function getRoadOrJunctionNumber()
    {
        return $this->roadOrJunctionNumber;
    }
    /**
     * Set roadOrJunctionNumber value
     * @param string $roadOrJunctionNumber
     * @return \StructType\ReroutingManagement
     */
    public function setRoadOrJunctionNumber($roadOrJunctionNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($roadOrJunctionNumber) && strlen($roadOrJunctionNumber) > 1024) || (is_array($roadOrJunctionNumber) && count($roadOrJunctionNumber) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($roadOrJunctionNumber) ? strlen($roadOrJunctionNumber) : count($roadOrJunctionNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($roadOrJunctionNumber) && !is_string($roadOrJunctionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roadOrJunctionNumber)), __LINE__);
        }
        $this->roadOrJunctionNumber = $roadOrJunctionNumber;
        return $this;
    }
    /**
     * Get alternativeRoute value
     * @return \StructType\Itinerary[]|null
     */
    public function getAlternativeRoute()
    {
        return $this->alternativeRoute;
    }
    /**
     * Set alternativeRoute value
     * @throws \InvalidArgumentException
     * @param \StructType\Itinerary[] $alternativeRoute
     * @return \StructType\ReroutingManagement
     */
    public function setAlternativeRoute(array $alternativeRoute = array())
    {
        foreach ($alternativeRoute as $reroutingManagementAlternativeRouteItem) {
            // validation for constraint: itemType
            if (!$reroutingManagementAlternativeRouteItem instanceof \StructType\Itinerary) {
                throw new \InvalidArgumentException(sprintf('The alternativeRoute property can only contain items of \StructType\Itinerary, "%s" given', is_object($reroutingManagementAlternativeRouteItem) ? get_class($reroutingManagementAlternativeRouteItem) : gettype($reroutingManagementAlternativeRouteItem)), __LINE__);
            }
        }
        $this->alternativeRoute = $alternativeRoute;
        return $this;
    }
    /**
     * Add item to alternativeRoute value
     * @throws \InvalidArgumentException
     * @param \StructType\Itinerary $item
     * @return \StructType\ReroutingManagement
     */
    public function addToAlternativeRoute(\StructType\Itinerary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Itinerary) {
            throw new \InvalidArgumentException(sprintf('The alternativeRoute property can only contain items of \StructType\Itinerary, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->alternativeRoute[] = $item;
        return $this;
    }
    /**
     * Get reroutingManagementExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getReroutingManagementExtension()
    {
        return $this->reroutingManagementExtension;
    }
    /**
     * Set reroutingManagementExtension value
     * @param \StructType\ExtensionType $reroutingManagementExtension
     * @return \StructType\ReroutingManagement
     */
    public function setReroutingManagementExtension(\StructType\ExtensionType $reroutingManagementExtension = null)
    {
        $this->reroutingManagementExtension = $reroutingManagementExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReroutingManagement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
