<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Repetitions StructType
 * Meta informations extracted from the WSDL
 * - documentation: situation applies only on the repeated day types within the overall validity period(s). For example Sunday.
 * - minOccurs: 0
 * @subpackage Structs
 */
class Repetitions extends AbstractStructBase
{
    /**
     * The DayType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: DayType
     * @var string[]
     */
    public $DayType;
    /**
     * Constructor method for Repetitions
     * @uses Repetitions::setDayType()
     * @param string[] $dayType
     */
    public function __construct(array $dayType = array())
    {
        $this
            ->setDayType($dayType);
    }
    /**
     * Get DayType value
     * @return string[]|null
     */
    public function getDayType()
    {
        return $this->DayType;
    }
    /**
     * Set DayType value
     * @uses \EnumType\DayTypeEnumeration::valueIsValid()
     * @uses \EnumType\DayTypeEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $dayType
     * @return \StructType\Repetitions
     */
    public function setDayType(array $dayType = array())
    {
        $invalidValues = array();
        foreach ($dayType as $repetitionsDayTypeItem) {
            if (!\EnumType\DayTypeEnumeration::valueIsValid($repetitionsDayTypeItem)) {
                $invalidValues[] = var_export($repetitionsDayTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\DayTypeEnumeration::getValidValues())), __LINE__);
        }
        $this->DayType = $dayType;
        return $this;
    }
    /**
     * Add item to DayType value
     * @uses \EnumType\DayTypeEnumeration::valueIsValid()
     * @uses \EnumType\DayTypeEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Repetitions
     */
    public function addToDayType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DayTypeEnumeration::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\DayTypeEnumeration::getValidValues())), __LINE__);
        }
        $this->DayType[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Repetitions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
