<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferencesStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for references.
 * @subpackage Structs
 */
class ReferencesStructure extends AbstractStructBase
{
    /**
     * The RelatedToRef
     * Meta informations extracted from the WSDL
     * - documentation: A reference to another SITUATION with an indication of the nature of the association, e.g. a cause, a result, an update. Note that a Entry that is an update, i.e. has the same IdentifierNumber but a later version number as a previous
     * Entry alway has a supercedes relationship and this does not need to be expliciitly coded.
     * - maxOccurs: unbounded
     * @var \StructType\RelatedSituationStructure[]
     */
    public $RelatedToRef;
    /**
     * Constructor method for ReferencesStructure
     * @uses ReferencesStructure::setRelatedToRef()
     * @param \StructType\RelatedSituationStructure[] $relatedToRef
     */
    public function __construct(array $relatedToRef = array())
    {
        $this
            ->setRelatedToRef($relatedToRef);
    }
    /**
     * Get RelatedToRef value
     * @return \StructType\RelatedSituationStructure[]|null
     */
    public function getRelatedToRef()
    {
        return $this->RelatedToRef;
    }
    /**
     * Set RelatedToRef value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatedSituationStructure[] $relatedToRef
     * @return \StructType\ReferencesStructure
     */
    public function setRelatedToRef(array $relatedToRef = array())
    {
        foreach ($relatedToRef as $referencesStructureRelatedToRefItem) {
            // validation for constraint: itemType
            if (!$referencesStructureRelatedToRefItem instanceof \StructType\RelatedSituationStructure) {
                throw new \InvalidArgumentException(sprintf('The RelatedToRef property can only contain items of \StructType\RelatedSituationStructure, "%s" given', is_object($referencesStructureRelatedToRefItem) ? get_class($referencesStructureRelatedToRefItem) : gettype($referencesStructureRelatedToRefItem)), __LINE__);
            }
        }
        $this->RelatedToRef = $relatedToRef;
        return $this;
    }
    /**
     * Add item to RelatedToRef value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatedSituationStructure $item
     * @return \StructType\ReferencesStructure
     */
    public function addToRelatedToRef(\StructType\RelatedSituationStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RelatedSituationStructure) {
            throw new \InvalidArgumentException(sprintf('The RelatedToRef property can only contain items of \StructType\RelatedSituationStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RelatedToRef[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReferencesStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
