<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceSettings StructType
 * @subpackage Structs
 */
class ReferenceSettings extends AbstractStructBase
{
    /**
     * The predefinedLocationSetReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $predefinedLocationSetReference;
    /**
     * The trafficStatusDefault
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trafficStatusDefault;
    /**
     * The referenceSettingsExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $referenceSettingsExtension;
    /**
     * Constructor method for ReferenceSettings
     * @uses ReferenceSettings::setPredefinedLocationSetReference()
     * @uses ReferenceSettings::setTrafficStatusDefault()
     * @uses ReferenceSettings::setReferenceSettingsExtension()
     * @param string $predefinedLocationSetReference
     * @param string $trafficStatusDefault
     * @param \StructType\ExtensionType $referenceSettingsExtension
     */
    public function __construct($predefinedLocationSetReference = null, $trafficStatusDefault = null, \StructType\ExtensionType $referenceSettingsExtension = null)
    {
        $this
            ->setPredefinedLocationSetReference($predefinedLocationSetReference)
            ->setTrafficStatusDefault($trafficStatusDefault)
            ->setReferenceSettingsExtension($referenceSettingsExtension);
    }
    /**
     * Get predefinedLocationSetReference value
     * @return string|null
     */
    public function getPredefinedLocationSetReference()
    {
        return $this->predefinedLocationSetReference;
    }
    /**
     * Set predefinedLocationSetReference value
     * @param string $predefinedLocationSetReference
     * @return \StructType\ReferenceSettings
     */
    public function setPredefinedLocationSetReference($predefinedLocationSetReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($predefinedLocationSetReference) && strlen($predefinedLocationSetReference) > 1024) || (is_array($predefinedLocationSetReference) && count($predefinedLocationSetReference) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($predefinedLocationSetReference) ? strlen($predefinedLocationSetReference) : count($predefinedLocationSetReference)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($predefinedLocationSetReference) && !is_string($predefinedLocationSetReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($predefinedLocationSetReference)), __LINE__);
        }
        $this->predefinedLocationSetReference = $predefinedLocationSetReference;
        return $this;
    }
    /**
     * Get trafficStatusDefault value
     * @return string|null
     */
    public function getTrafficStatusDefault()
    {
        return $this->trafficStatusDefault;
    }
    /**
     * Set trafficStatusDefault value
     * @uses \EnumType\TrafficStatusEnum::valueIsValid()
     * @uses \EnumType\TrafficStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trafficStatusDefault
     * @return \StructType\ReferenceSettings
     */
    public function setTrafficStatusDefault($trafficStatusDefault = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TrafficStatusEnum::valueIsValid($trafficStatusDefault)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trafficStatusDefault, implode(', ', \EnumType\TrafficStatusEnum::getValidValues())), __LINE__);
        }
        $this->trafficStatusDefault = $trafficStatusDefault;
        return $this;
    }
    /**
     * Get referenceSettingsExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getReferenceSettingsExtension()
    {
        return $this->referenceSettingsExtension;
    }
    /**
     * Set referenceSettingsExtension value
     * @param \StructType\ExtensionType $referenceSettingsExtension
     * @return \StructType\ReferenceSettings
     */
    public function setReferenceSettingsExtension(\StructType\ExtensionType $referenceSettingsExtension = null)
    {
        $this->referenceSettingsExtension = $referenceSettingsExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReferenceSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
