<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PushedActionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for publication action.
 * @subpackage Structs
 */
class PushedActionStructure extends ParameterisedActionStructure
{
    /**
     * The BeforeNotices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BeforeNotices
     */
    public $BeforeNotices;
    /**
     * The ClearNotice
     * Meta informations extracted from the WSDL
     * - documentation: Whether a clearing notice should be displayed.
     * - minOccurs: 0
     * @var bool
     */
    public $ClearNotice;
    /**
     * Constructor method for PushedActionStructure
     * @uses PushedActionStructure::setBeforeNotices()
     * @uses PushedActionStructure::setClearNotice()
     * @param \StructType\BeforeNotices $beforeNotices
     * @param bool $clearNotice
     */
    public function __construct(\StructType\BeforeNotices $beforeNotices = null, $clearNotice = null)
    {
        $this
            ->setBeforeNotices($beforeNotices)
            ->setClearNotice($clearNotice);
    }
    /**
     * Get BeforeNotices value
     * @return \StructType\BeforeNotices|null
     */
    public function getBeforeNotices()
    {
        return $this->BeforeNotices;
    }
    /**
     * Set BeforeNotices value
     * @param \StructType\BeforeNotices $beforeNotices
     * @return \StructType\PushedActionStructure
     */
    public function setBeforeNotices(\StructType\BeforeNotices $beforeNotices = null)
    {
        $this->BeforeNotices = $beforeNotices;
        return $this;
    }
    /**
     * Get ClearNotice value
     * @return bool|null
     */
    public function getClearNotice()
    {
        return $this->ClearNotice;
    }
    /**
     * Set ClearNotice value
     * @param bool $clearNotice
     * @return \StructType\PushedActionStructure
     */
    public function setClearNotice($clearNotice = null)
    {
        // validation for constraint: boolean
        if (!is_null($clearNotice) && !is_bool($clearNotice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($clearNotice)), __LINE__);
        }
        $this->ClearNotice = $clearNotice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PushedActionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
