<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PublishToMobileActionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Action Publish SITUATION To Displays.
 * @subpackage Structs
 */
class PublishToMobileActionStructure extends ParameterisedActionStructure
{
    /**
     * The Incidents
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Include in SITUATION lists on mobile site. Default is 'true'.
     * - minOccurs: 0
     * @var bool
     */
    public $Incidents;
    /**
     * The HomePage
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Include in home page on mobile site. Default is 'false'.
     * - minOccurs: 0
     * @var bool
     */
    public $HomePage;
    /**
     * Constructor method for PublishToMobileActionStructure
     * @uses PublishToMobileActionStructure::setIncidents()
     * @uses PublishToMobileActionStructure::setHomePage()
     * @param bool $incidents
     * @param bool $homePage
     */
    public function __construct($incidents = true, $homePage = false)
    {
        $this
            ->setIncidents($incidents)
            ->setHomePage($homePage);
    }
    /**
     * Get Incidents value
     * @return bool|null
     */
    public function getIncidents()
    {
        return $this->Incidents;
    }
    /**
     * Set Incidents value
     * @param bool $incidents
     * @return \StructType\PublishToMobileActionStructure
     */
    public function setIncidents($incidents = true)
    {
        // validation for constraint: boolean
        if (!is_null($incidents) && !is_bool($incidents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($incidents)), __LINE__);
        }
        $this->Incidents = $incidents;
        return $this;
    }
    /**
     * Get HomePage value
     * @return bool|null
     */
    public function getHomePage()
    {
        return $this->HomePage;
    }
    /**
     * Set HomePage value
     * @param bool $homePage
     * @return \StructType\PublishToMobileActionStructure
     */
    public function setHomePage($homePage = false)
    {
        // validation for constraint: boolean
        if (!is_null($homePage) && !is_bool($homePage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($homePage)), __LINE__);
        }
        $this->HomePage = $homePage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PublishToMobileActionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
