<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PublishToDisplayActionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Action Publish SITUATION To Web.
 * @subpackage Structs
 */
class PublishToDisplayActionStructure extends ParameterisedActionStructure
{
    /**
     * The OnPlace
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Include in SITUATION lists on station displays.
     * - minOccurs: 0
     * @var bool
     */
    public $OnPlace;
    /**
     * The OnBoard
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Include onboard displays.
     * - minOccurs: 0
     * @var bool
     */
    public $OnBoard;
    /**
     * Constructor method for PublishToDisplayActionStructure
     * @uses PublishToDisplayActionStructure::setOnPlace()
     * @uses PublishToDisplayActionStructure::setOnBoard()
     * @param bool $onPlace
     * @param bool $onBoard
     */
    public function __construct($onPlace = true, $onBoard = false)
    {
        $this
            ->setOnPlace($onPlace)
            ->setOnBoard($onBoard);
    }
    /**
     * Get OnPlace value
     * @return bool|null
     */
    public function getOnPlace()
    {
        return $this->OnPlace;
    }
    /**
     * Set OnPlace value
     * @param bool $onPlace
     * @return \StructType\PublishToDisplayActionStructure
     */
    public function setOnPlace($onPlace = true)
    {
        // validation for constraint: boolean
        if (!is_null($onPlace) && !is_bool($onPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($onPlace)), __LINE__);
        }
        $this->OnPlace = $onPlace;
        return $this;
    }
    /**
     * Get OnBoard value
     * @return bool|null
     */
    public function getOnBoard()
    {
        return $this->OnBoard;
    }
    /**
     * Set OnBoard value
     * @param bool $onBoard
     * @return \StructType\PublishToDisplayActionStructure
     */
    public function setOnBoard($onBoard = false)
    {
        // validation for constraint: boolean
        if (!is_null($onBoard) && !is_bool($onBoard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($onBoard)), __LINE__);
        }
        $this->OnBoard = $onBoard;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PublishToDisplayActionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
