<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PublishToAlertsActionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Action Publish SITUATION To Alert Service.
 * @subpackage Structs
 */
class PublishToAlertsActionStructure extends PushedActionStructure
{
    /**
     * The ByEmail
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Send as email alert.
     * - minOccurs: 0
     * @var bool
     */
    public $ByEmail;
    /**
     * The ByMobile
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Send as mobile alert by SMS or WAP push.
     * - minOccurs: 0
     * @var bool
     */
    public $ByMobile;
    /**
     * Constructor method for PublishToAlertsActionStructure
     * @uses PublishToAlertsActionStructure::setByEmail()
     * @uses PublishToAlertsActionStructure::setByMobile()
     * @param bool $byEmail
     * @param bool $byMobile
     */
    public function __construct($byEmail = true, $byMobile = true)
    {
        $this
            ->setByEmail($byEmail)
            ->setByMobile($byMobile);
    }
    /**
     * Get ByEmail value
     * @return bool|null
     */
    public function getByEmail()
    {
        return $this->ByEmail;
    }
    /**
     * Set ByEmail value
     * @param bool $byEmail
     * @return \StructType\PublishToAlertsActionStructure
     */
    public function setByEmail($byEmail = true)
    {
        // validation for constraint: boolean
        if (!is_null($byEmail) && !is_bool($byEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($byEmail)), __LINE__);
        }
        $this->ByEmail = $byEmail;
        return $this;
    }
    /**
     * Get ByMobile value
     * @return bool|null
     */
    public function getByMobile()
    {
        return $this->ByMobile;
    }
    /**
     * Set ByMobile value
     * @param bool $byMobile
     * @return \StructType\PublishToAlertsActionStructure
     */
    public function setByMobile($byMobile = true)
    {
        // validation for constraint: boolean
        if (!is_null($byMobile) && !is_bool($byMobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($byMobile)), __LINE__);
        }
        $this->ByMobile = $byMobile;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PublishToAlertsActionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
