<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProgressBetweenStopsStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Progress between stops.
 * @subpackage Structs
 */
class ProgressBetweenStopsStructure extends AbstractStructBase
{
    /**
     * The LinkDistance
     * Meta informations extracted from the WSDL
     * - documentation: The total distance in metres between the previous stop and the next stop.
     * - minOccurs: 0
     * @var float
     */
    public $LinkDistance;
    /**
     * The Percentage
     * Meta informations extracted from the WSDL
     * - documentation: Percentage along link that VEHICLE has travelled.
     * - minOccurs: 0
     * @var float
     */
    public $Percentage;
    /**
     * Constructor method for ProgressBetweenStopsStructure
     * @uses ProgressBetweenStopsStructure::setLinkDistance()
     * @uses ProgressBetweenStopsStructure::setPercentage()
     * @param float $linkDistance
     * @param float $percentage
     */
    public function __construct($linkDistance = null, $percentage = null)
    {
        $this
            ->setLinkDistance($linkDistance)
            ->setPercentage($percentage);
    }
    /**
     * Get LinkDistance value
     * @return float|null
     */
    public function getLinkDistance()
    {
        return $this->LinkDistance;
    }
    /**
     * Set LinkDistance value
     * @param float $linkDistance
     * @return \StructType\ProgressBetweenStopsStructure
     */
    public function setLinkDistance($linkDistance = null)
    {
        $this->LinkDistance = $linkDistance;
        return $this;
    }
    /**
     * Get Percentage value
     * @return float|null
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param float $percentage
     * @return \StructType\ProgressBetweenStopsStructure
     */
    public function setPercentage($percentage = null)
    {
        $this->Percentage = $percentage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProgressBetweenStopsStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
